@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The SAP instance specific configuration data.
 * @property cpu Provide the CPU value of the server. For example, 16, 32 etc.
 * @property cpuInMhz Provide the CPU clock speed of the server in MHz. This should be a non-zero value. For example, 2100.
 * @property cpuType Provide the CPU architecture type of the server. For example, Xeon Platinum 8171M, Xeon E5-2673 v3.
 * @property databaseType The database of this is a server instance. Applicable only if SAP instance type for this server instance is 'DB'.
 * @property hardwareManufacturer Provide the HW manufacturer company of the server.  For example, Microsoft Corporation.
 * @property model Specify if the Hardware is a physical server or virtual machine.
 * @property ram Provide the RAM of the server. This should be a non-zero value. For example, 256.
 * @property saps Provide the SAPS for each server of the SAP system. This should be a non-zero value. For example, 1000.
 * @property targetHanaRamSizeGB Provide the target HANA database size you need. Applicable only if SAP instance type for this server instance is 'DB' and you are migrating an AnyDb database to SAP S/4HANA.
 * @property totalDiskIops Provide the total disk IOPS capacity. Add the disk volume for each individual disk and provide the sum total in this field.
 * @property totalDiskSizeGB Provide the total disk volume capacity in GB. Add the disk volume for each individual disks and provide the total sum in this field.
 */
public data class ConfigurationDataResponse(
    public val cpu: Int,
    public val cpuInMhz: Int,
    public val cpuType: String,
    public val databaseType: String,
    public val hardwareManufacturer: String,
    public val model: String,
    public val ram: Int,
    public val saps: Int,
    public val targetHanaRamSizeGB: Int,
    public val totalDiskIops: Int,
    public val totalDiskSizeGB: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.ConfigurationDataResponse): ConfigurationDataResponse = ConfigurationDataResponse(
            cpu = javaType.cpu(),
            cpuInMhz = javaType.cpuInMhz(),
            cpuType = javaType.cpuType(),
            databaseType = javaType.databaseType(),
            hardwareManufacturer = javaType.hardwareManufacturer(),
            model = javaType.model(),
            ram = javaType.ram(),
            saps = javaType.saps(),
            targetHanaRamSizeGB = javaType.targetHanaRamSizeGB(),
            totalDiskIops = javaType.totalDiskIops(),
            totalDiskSizeGB = javaType.totalDiskSizeGB(),
        )
    }
}
