@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The full resource names object for database layer resources. The number of entries in this list should be equal to the number VMs to be created for database layer.
 * @property availabilitySetName The full name for availability set. In case name is not provided, it will be defaulted to {SID}-DB-AvSet.
 * @property loadBalancer The resource names object for load balancer and related resources.
 * @property virtualMachines The list of virtual machine naming details.
 */
public data class DatabaseServerFullResourceNamesResponse(
    public val availabilitySetName: String? = null,
    public val loadBalancer: LoadBalancerResourceNamesResponse? = null,
    public val virtualMachines: List<VirtualMachineResourceNamesResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.DatabaseServerFullResourceNamesResponse): DatabaseServerFullResourceNamesResponse = DatabaseServerFullResourceNamesResponse(
            availabilitySetName = javaType.availabilitySetName().map({ args0 -> args0 }).orElse(null),
            loadBalancer = javaType.loadBalancer().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.LoadBalancerResourceNamesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            virtualMachines = javaType.virtualMachines().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.VirtualMachineResourceNamesResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
