@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Discovery Details.
 * @property appLocation The geo-location where the SAP system exists.
 * @property centralServerVmId The virtual machine ID of the Central Server.
 * @property configurationType The configuration Type.
 * Expected value is 'Discovery'.
 * @property managedRgStorageAccountName The custom storage account name for the storage account created by the service in the managed resource group created as part of VIS deployment.<br><br>Refer to the storage account naming rules [here](https://learn.microsoft.com/azure/azure-resource-manager/management/resource-name-rules#microsoftstorage).<br><br>If not provided, the service will create the storage account with a random name.
 */
public data class DiscoveryConfigurationResponse(
    public val appLocation: String,
    public val centralServerVmId: String? = null,
    public val configurationType: String,
    public val managedRgStorageAccountName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.DiscoveryConfigurationResponse): DiscoveryConfigurationResponse = DiscoveryConfigurationResponse(
            appLocation = javaType.appLocation(),
            centralServerVmId = javaType.centralServerVmId().map({ args0 -> args0 }).orElse(null),
            configurationType = javaType.configurationType(),
            managedRgStorageAccountName = javaType.managedRgStorageAccountName().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
