@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The type of disk sku. For example, Standard_LRS, Standard_ZRS, Premium_LRS, Premium_ZRS.
 * @property name Defines the disk sku name.
 */
public data class DiskSkuResponse(
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.DiskSkuResponse): DiskSkuResponse = DiskSkuResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
