@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 * The disk configuration required for the selected volume.
 * @property count The total number of disks required for the concerned volume.
 * @property sizeGB The disk size in GB.
 * @property sku The disk SKU details.
 */
public data class DiskVolumeConfigurationResponse(
    public val count: Double? = null,
    public val sizeGB: Double? = null,
    public val sku: DiskSkuResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.DiskVolumeConfigurationResponse): DiskVolumeConfigurationResponse = DiskVolumeConfigurationResponse(
            count = javaType.count().map({ args0 -> args0 }).orElse(null),
            sizeGB = javaType.sizeGB().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.DiskSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
