@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Defines the SAP Enqueue Server properties.
 * @property health Defines the health of SAP Instances.
 * @property hostname Enqueue Server SAP Hostname.
 * @property ipAddress Enqueue Server SAP IP Address.
 * @property port Enqueue Server Port.
 */
public data class EnqueueServerPropertiesResponse(
    public val health: String,
    public val hostname: String,
    public val ipAddress: String,
    public val port: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.EnqueueServerPropertiesResponse): EnqueueServerPropertiesResponse = EnqueueServerPropertiesResponse(
            health = javaType.health(),
            hostname = javaType.hostname(),
            ipAddress = javaType.ipAddress(),
            port = javaType.port(),
        )
    }
}
