@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The SAP instance specific performance data for Excel import.
 * @property dataSource The data source for this resource.
 * Expected value is 'Excel'.
 * @property maxCpuLoad Provide the max CPU percentage load on the server. Omit the percentage symbol while filling this value.
 * @property totalSourceDbSizeGB Provide the source Database size in GB. Applicable only if SAP instance type for this server instance is 'DB'.
 */
public data class ExcelPerformanceDataResponse(
    public val dataSource: String,
    public val maxCpuLoad: Int,
    public val totalSourceDbSizeGB: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.ExcelPerformanceDataResponse): ExcelPerformanceDataResponse = ExcelPerformanceDataResponse(
            dataSource = javaType.dataSource(),
            maxCpuLoad = javaType.maxCpuLoad(),
            totalSourceDbSizeGB = javaType.totalSourceDbSizeGB(),
        )
    }
}
