@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Defines the SAP Gateway Server properties.
 * @property health Defines the health of SAP Instances.
 * @property port Gateway Port.
 */
public data class GatewayServerPropertiesResponse(
    public val health: String,
    public val port: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.GatewayServerPropertiesResponse): GatewayServerPropertiesResponse = GatewayServerPropertiesResponse(
            health = javaType.health(),
            port = javaType.port(),
        )
    }
}
