@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * SAP monitor info on Azure (ARM properties and SAP monitor properties)
 * @property appLocation The SAP monitor resources will be deployed in the SAP monitoring region. The subnet region should be same as the SAP monitoring region.
 * @property errors Defines the SAP monitor errors.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity [currently not in use] Managed service identity(user assigned identities)
 * @property location The geo-location where the resource lives
 * @property logAnalyticsWorkspaceArmId The ARM ID of the Log Analytics Workspace that is used for SAP monitoring.
 * @property managedResourceGroupConfiguration Managed resource group configuration
 * @property monitorSubnet The subnet which the SAP monitor will be deployed in
 * @property msiArmId The ARM ID of the MSI used for SAP monitoring.
 * @property name The name of the resource
 * @property provisioningState State of provisioning of the SAP monitor.
 * @property routingPreference Sets the routing preference of the SAP monitor. By default only RFC1918 traffic is routed to the customer VNET.
 * @property storageAccountArmId The ARM ID of the Storage account used for SAP monitoring.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property zoneRedundancyPreference Sets the preference for zone redundancy on resources created for the SAP monitor. By default resources will be created which do not support zone redundancy.
 */
public data class GetMonitorResult(
    public val appLocation: String? = null,
    public val errors: MonitorPropertiesResponseErrors,
    public val id: String,
    public val identity: UserAssignedServiceIdentityResponse? = null,
    public val location: String,
    public val logAnalyticsWorkspaceArmId: String? = null,
    public val managedResourceGroupConfiguration: ManagedRGConfigurationResponse? = null,
    public val monitorSubnet: String? = null,
    public val msiArmId: String,
    public val name: String,
    public val provisioningState: String,
    public val routingPreference: String? = null,
    public val storageAccountArmId: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val zoneRedundancyPreference: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.GetMonitorResult): GetMonitorResult = GetMonitorResult(
            appLocation = javaType.appLocation().map({ args0 -> args0 }).orElse(null),
            errors = javaType.errors().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.MonitorPropertiesResponseErrors.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.UserAssignedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            logAnalyticsWorkspaceArmId = javaType.logAnalyticsWorkspaceArmId().map({ args0 ->
                args0
            }).orElse(null),
            managedResourceGroupConfiguration = javaType.managedResourceGroupConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.ManagedRGConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            monitorSubnet = javaType.monitorSubnet().map({ args0 -> args0 }).orElse(null),
            msiArmId = javaType.msiArmId(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            routingPreference = javaType.routingPreference().map({ args0 -> args0 }).orElse(null),
            storageAccountArmId = javaType.storageAccountArmId(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            zoneRedundancyPreference = javaType.zoneRedundancyPreference().map({ args0 -> args0 }).orElse(null),
        )
    }
}
