@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Define the SAP Central Services Instance resource.
 * @property enqueueReplicationServerProperties Defines the SAP Enqueue Replication Server (ERS) properties.
 * @property enqueueServerProperties Defines the SAP Enqueue Server properties.
 * @property errors Defines the errors related to SAP Central Services Instance resource.
 * @property gatewayServerProperties Defines the SAP Gateway Server properties.
 * @property health Defines the health of SAP Instances.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property instanceNo The central services instance number.
 * @property kernelPatch The central services instance Kernel Patch level.
 * @property kernelVersion The central services instance Kernel Version.
 * @property loadBalancerDetails The Load Balancer details such as LoadBalancer ID attached to ASCS Virtual Machines
 * @property location The geo-location where the resource lives
 * @property messageServerProperties Defines the SAP Message Server properties.
 * @property name The name of the resource
 * @property provisioningState Defines the provisioning states.
 * @property status Defines the SAP Instance status.
 * @property subnet The central services instance subnet.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property vmDetails The list of virtual machines corresponding to the Central Services instance.
 */
public data class GetSAPCentralInstanceResult(
    public val enqueueReplicationServerProperties: EnqueueReplicationServerPropertiesResponse? = null,
    public val enqueueServerProperties: EnqueueServerPropertiesResponse? = null,
    public val errors: SAPVirtualInstanceErrorResponse,
    public val gatewayServerProperties: GatewayServerPropertiesResponse? = null,
    public val health: String,
    public val id: String,
    public val instanceNo: String,
    public val kernelPatch: String,
    public val kernelVersion: String,
    public val loadBalancerDetails: LoadBalancerDetailsResponse,
    public val location: String,
    public val messageServerProperties: MessageServerPropertiesResponse? = null,
    public val name: String,
    public val provisioningState: String,
    public val status: String,
    public val subnet: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val vmDetails: List<CentralServerVmDetailsResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.GetSAPCentralInstanceResult): GetSAPCentralInstanceResult = GetSAPCentralInstanceResult(
            enqueueReplicationServerProperties = javaType.enqueueReplicationServerProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.EnqueueReplicationServerPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            enqueueServerProperties = javaType.enqueueServerProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.EnqueueServerPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            errors = javaType.errors().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.SAPVirtualInstanceErrorResponse.Companion.toKotlin(args0)
            }),
            gatewayServerProperties = javaType.gatewayServerProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.GatewayServerPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            health = javaType.health(),
            id = javaType.id(),
            instanceNo = javaType.instanceNo(),
            kernelPatch = javaType.kernelPatch(),
            kernelVersion = javaType.kernelVersion(),
            loadBalancerDetails = javaType.loadBalancerDetails().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.LoadBalancerDetailsResponse.Companion.toKotlin(args0)
            }),
            location = javaType.location(),
            messageServerProperties = javaType.messageServerProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.MessageServerPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            status = javaType.status(),
            subnet = javaType.subnet(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            vmDetails = javaType.vmDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.CentralServerVmDetailsResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
