@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Define the Database resource.
 * @property databaseSid Database SID name.
 * @property databaseType Database type, that is if the DB is HANA, DB2, Oracle, SAP ASE, Max DB or MS SQL Server.
 * @property errors Defines the errors related to Database resource.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property ipAddress Database IP Address.
 * @property loadBalancerDetails The Load Balancer details such as LoadBalancer ID attached to Database Virtual Machines
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState Defines the provisioning states.
 * @property status Defines the SAP Instance status.
 * @property subnet Database subnet.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property vmDetails The list of virtual machines corresponding to the Database resource.
 */
public data class GetSAPDatabaseInstanceResult(
    public val databaseSid: String,
    public val databaseType: String,
    public val errors: SAPVirtualInstanceErrorResponse,
    public val id: String,
    public val ipAddress: String,
    public val loadBalancerDetails: LoadBalancerDetailsResponse,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val status: String,
    public val subnet: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val vmDetails: List<DatabaseVmDetailsResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.GetSAPDatabaseInstanceResult): GetSAPDatabaseInstanceResult = GetSAPDatabaseInstanceResult(
            databaseSid = javaType.databaseSid(),
            databaseType = javaType.databaseType(),
            errors = javaType.errors().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.SAPVirtualInstanceErrorResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            ipAddress = javaType.ipAddress(),
            loadBalancerDetails = javaType.loadBalancerDetails().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.LoadBalancerDetailsResponse.Companion.toKotlin(args0)
            }),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            status = javaType.status(),
            subnet = javaType.subnet(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            vmDetails = javaType.vmDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.DatabaseVmDetailsResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
