@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The list of supported SKUs for different resources which are part of SAP deployment.
 * @property supportedSkus Gets the list of SAP supported SKUs.
 */
public data class GetSAPSupportedSkuResult(
    public val supportedSkus: List<SAPSupportedSkuResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.GetSAPSupportedSkuResult): GetSAPSupportedSkuResult = GetSAPSupportedSkuResult(
            supportedSkus = javaType.supportedSkus().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.SAPSupportedSkuResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
