@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Define the SAP Migration discovery site resource.
 * @property errors Indicates any errors on the SAP Migration discovery site resource.
 * @property extendedLocation The extended location definition.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property masterSiteId The master site ID from Azure Migrate.
 * @property migrateProjectId The migrate project ID from Azure Migrate.
 * @property name The name of the resource
 * @property provisioningState Defines the provisioning states.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetSapDiscoverySiteResult(
    public val errors: SAPMigrateErrorResponse,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val id: String,
    public val location: String,
    public val masterSiteId: String? = null,
    public val migrateProjectId: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.GetSapDiscoverySiteResult): GetSapDiscoverySiteResult = GetSapDiscoverySiteResult(
            errors = javaType.errors().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.SAPMigrateErrorResponse.Companion.toKotlin(args0)
            }),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            masterSiteId = javaType.masterSiteId().map({ args0 -> args0 }).orElse(null),
            migrateProjectId = javaType.migrateProjectId().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
