@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Define the SAP Instance resource.
 * @property application Enter a business function/department identifier to group multiple SIDs.
 * @property environment The Environment; PRD, QA, DEV, etc to which SAP system belongs to. Select from the list of available dropdown values.
 * @property errors Defines the errors related to SAP Instance resource.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property landscapeSid This is the SID of the production system in a landscape.  An SAP system could itself be a production SID or a part of a landscape with a different Production SID. This field can be used to relate non-prod SIDs, other components, SID (WEBDISP) to the prod SID. Enter the value of Production SID.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState Defines the provisioning states.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property systemSid This is the SID of SAP System. Keeping this not equal to ID as different landscapes can have repeated System SID IDs.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetSapInstanceResult(
    public val application: String,
    public val environment: String,
    public val errors: SAPMigrateErrorResponse,
    public val id: String,
    public val landscapeSid: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val systemSid: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.GetSapInstanceResult): GetSapInstanceResult = GetSapInstanceResult(
            application = javaType.application(),
            environment = javaType.environment(),
            errors = javaType.errors().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.SAPMigrateErrorResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            landscapeSid = javaType.landscapeSid(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            systemSid = javaType.systemSid(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
