@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Gets or sets the HA software configuration.
 * @property fencingClientId The fencing client id.
 * @property fencingClientPassword The fencing client id secret/password. The secret should never expire. This will be used pacemaker to start/stop the cluster VMs.
 */
public data class HighAvailabilitySoftwareConfigurationResponse(
    public val fencingClientId: String,
    public val fencingClientPassword: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.HighAvailabilitySoftwareConfigurationResponse): HighAvailabilitySoftwareConfigurationResponse =
            HighAvailabilitySoftwareConfigurationResponse(
                fencingClientId = javaType.fencingClientId(),
                fencingClientPassword = javaType.fencingClientPassword(),
            )
    }
}
