@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Instant recovery point additional details.
 * @property azureBackupRGNamePrefix Azure backup resource group name prefix.
 * @property azureBackupRGNameSuffix Azure backup resource group name suffix.
 */
public data class InstantRPAdditionalDetailsResponse(
    public val azureBackupRGNamePrefix: String? = null,
    public val azureBackupRGNameSuffix: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.InstantRPAdditionalDetailsResponse): InstantRPAdditionalDetailsResponse = InstantRPAdditionalDetailsResponse(
            azureBackupRGNamePrefix = javaType.azureBackupRGNamePrefix().map({ args0 -> args0 }).orElse(null),
            azureBackupRGNameSuffix = javaType.azureBackupRGNameSuffix().map({ args0 -> args0 }).orElse(null),
        )
    }
}
