@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The resource names object for load balancer and related resources.
 * @property backendPoolNames The list of backend pool names. Currently, ACSS deploys only one backend pool and hence, size of this list should be 1
 * @property frontendIpConfigurationNames The list of frontend IP configuration names. If provided as input, size of this list should be 2 for cs layer and should be 1 for database layer.
 * @property healthProbeNames The list of health probe names. If provided as input, size of this list should be 2 for cs layer and should be 1 for database layer.
 * @property loadBalancerName The full resource name for load balancer. If this value is not provided, load balancer will be name as {ASCS/DB}-loadBalancer.
 */
public data class LoadBalancerResourceNamesResponse(
    public val backendPoolNames: List<String>? = null,
    public val frontendIpConfigurationNames: List<String>? = null,
    public val healthProbeNames: List<String>? = null,
    public val loadBalancerName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.LoadBalancerResourceNamesResponse): LoadBalancerResourceNamesResponse = LoadBalancerResourceNamesResponse(
            backendPoolNames = javaType.backendPoolNames().map({ args0 -> args0 }),
            frontendIpConfigurationNames = javaType.frontendIpConfigurationNames().map({ args0 -> args0 }),
            healthProbeNames = javaType.healthProbeNames().map({ args0 -> args0 }),
            loadBalancerName = javaType.loadBalancerName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
