@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Long term retention policy.
 * @property dailySchedule Daily retention schedule of the protection policy.
 * @property monthlySchedule Monthly retention schedule of the protection policy.
 * @property retentionPolicyType This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
 * Expected value is 'LongTermRetentionPolicy'.
 * @property weeklySchedule Weekly retention schedule of the protection policy.
 * @property yearlySchedule Yearly retention schedule of the protection policy.
 */
public data class LongTermRetentionPolicyResponse(
    public val dailySchedule: DailyRetentionScheduleResponse? = null,
    public val monthlySchedule: MonthlyRetentionScheduleResponse? = null,
    public val retentionPolicyType: String,
    public val weeklySchedule: WeeklyRetentionScheduleResponse? = null,
    public val yearlySchedule: YearlyRetentionScheduleResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.LongTermRetentionPolicyResponse): LongTermRetentionPolicyResponse = LongTermRetentionPolicyResponse(
            dailySchedule = javaType.dailySchedule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.DailyRetentionScheduleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            monthlySchedule = javaType.monthlySchedule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.MonthlyRetentionScheduleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            retentionPolicyType = javaType.retentionPolicyType(),
            weeklySchedule = javaType.weeklySchedule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.WeeklyRetentionScheduleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            yearlySchedule = javaType.yearlySchedule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.YearlyRetentionScheduleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
