@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The SAP instance specific performance data for native discovery.
 * @property dataSource The data source for this resource.
 * Expected value is 'Native'.
 */
public data class NativePerformanceDataResponse(
    public val dataSource: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.NativePerformanceDataResponse): NativePerformanceDataResponse = NativePerformanceDataResponse(
            dataSource = javaType.dataSource(),
        )
    }
}
