@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Defines the network configuration type for SAP system infrastructure that is being deployed
 * @property isSecondaryIpEnabled Specifies whether a secondary IP address should be added to the network interface on all VMs of the SAP system being deployed
 */
public data class NetworkConfigurationResponse(
    public val isSecondaryIpEnabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.NetworkConfigurationResponse): NetworkConfigurationResponse = NetworkConfigurationResponse(
            isSecondaryIpEnabled = javaType.isSecondaryIpEnabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
