@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the OS and SAP Configurations for Deployment
 * @property deployerVmPackages The url and storage account ID where deployer VM packages are uploaded
 * @property sapFqdn The FQDN to set for the SAP system
 */
public data class OsSapConfigurationResponse(
    public val deployerVmPackages: DeployerVmPackagesResponse? = null,
    public val sapFqdn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.OsSapConfigurationResponse): OsSapConfigurationResponse = OsSapConfigurationResponse(
            deployerVmPackages = javaType.deployerVmPackages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.DeployerVmPackagesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sapFqdn = javaType.sapFqdn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
