@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The SAP Software configuration Input when the software is to be installed by service without OS Configurations
 * @property bomUrl The URL to the SAP Build of Materials(BOM) file.
 * @property highAvailabilitySoftwareConfiguration Gets or sets the HA software configuration.
 * @property sapBitsStorageAccountId The SAP bits storage account id.
 * @property softwareInstallationType The SAP software installation Type.
 * Expected value is 'SAPInstallWithoutOSConfig'.
 * @property softwareVersion The software version to install.
 */
public data class SAPInstallWithoutOSConfigSoftwareConfigurationResponse(
    public val bomUrl: String,
    public val highAvailabilitySoftwareConfiguration: HighAvailabilitySoftwareConfigurationResponse? =
        null,
    public val sapBitsStorageAccountId: String,
    public val softwareInstallationType: String,
    public val softwareVersion: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.SAPInstallWithoutOSConfigSoftwareConfigurationResponse): SAPInstallWithoutOSConfigSoftwareConfigurationResponse =
            SAPInstallWithoutOSConfigSoftwareConfigurationResponse(
                bomUrl = javaType.bomUrl(),
                highAvailabilitySoftwareConfiguration = javaType.highAvailabilitySoftwareConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.workloads.kotlin.outputs.HighAvailabilitySoftwareConfigurationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                sapBitsStorageAccountId = javaType.sapBitsStorageAccountId(),
                softwareInstallationType = javaType.softwareInstallationType(),
                softwareVersion = javaType.softwareVersion(),
            )
    }
}
