@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * An error response from the SAP migrate resources.
 * @property code Service specific error code which serves as the substatus for the HTTP error code.
 * @property details Internal error details.
 * @property message Description of the error.
 * @property recommendation Description of the recommendation.
 */
public data class SAPMigrateErrorResponse(
    public val code: String,
    public val details: List<ErrorDefinitionResponse>,
    public val message: String,
    public val recommendation: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.SAPMigrateErrorResponse): SAPMigrateErrorResponse = SAPMigrateErrorResponse(
            code = javaType.code(),
            details = javaType.details().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.ErrorDefinitionResponse.Companion.toKotlin(args0)
                })
            }),
            message = javaType.message(),
            recommendation = javaType.recommendation(),
        )
    }
}
