@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Gets or sets the SID groupings by landscape and Environment.
 * @property landscape Gets or sets the list of landscape to SID mappings.
 * @property sapApplication Gets or sets the list of Sap Applications to SID mappings.
 */
public data class SapLandscapeMonitorPropertiesResponseGrouping(
    public val landscape: List<SapLandscapeMonitorSidMappingResponse>? = null,
    public val sapApplication: List<SapLandscapeMonitorSidMappingResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.SapLandscapeMonitorPropertiesResponseGrouping): SapLandscapeMonitorPropertiesResponseGrouping =
            SapLandscapeMonitorPropertiesResponseGrouping(
                landscape = javaType.landscape().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.workloads.kotlin.outputs.SapLandscapeMonitorSidMappingResponse.Companion.toKotlin(args0)
                    })
                }),
                sapApplication = javaType.sapApplication().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.workloads.kotlin.outputs.SapLandscapeMonitorSidMappingResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
