@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Gets or sets the mapping for SID to Environment/Applications.
 * @property name Gets or sets the name of the grouping.
 * @property topSid Gets or sets the list of SID's.
 */
public data class SapLandscapeMonitorSidMappingResponse(
    public val name: String? = null,
    public val topSid: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.SapLandscapeMonitorSidMappingResponse): SapLandscapeMonitorSidMappingResponse = SapLandscapeMonitorSidMappingResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            topSid = javaType.topSid().map({ args0 -> args0 }),
        )
    }
}
