@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Gets or sets the provider properties.
 * @property providerType The provider type. For example, the value can be SapHana.
 * Expected value is 'SapNetWeaver'.
 * @property sapClientId Gets or sets the SAP Client ID.
 * @property sapHostFileEntries Gets or sets the list of HostFile Entries
 * @property sapHostname Gets or sets the target virtual machine IP Address/FQDN.
 * @property sapInstanceNr Gets or sets the instance number of SAP NetWeaver.
 * @property sapPassword Sets the SAP password.
 * @property sapPasswordUri Gets or sets the key vault URI to secret with the SAP password.
 * @property sapPortNumber Gets or sets the SAP HTTP port number.
 * @property sapSid Gets or sets the SAP System Identifier
 * @property sapUsername Gets or sets the SAP user name.
 * @property sslCertificateUri Gets or sets the blob URI to SSL certificate for the SAP system.
 * @property sslPreference Gets or sets certificate preference if secure communication is enabled.
 */
public data class SapNetWeaverProviderInstancePropertiesResponse(
    public val providerType: String,
    public val sapClientId: String? = null,
    public val sapHostFileEntries: List<String>? = null,
    public val sapHostname: String? = null,
    public val sapInstanceNr: String? = null,
    public val sapPassword: String? = null,
    public val sapPasswordUri: String? = null,
    public val sapPortNumber: String? = null,
    public val sapSid: String? = null,
    public val sapUsername: String? = null,
    public val sslCertificateUri: String? = null,
    public val sslPreference: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.SapNetWeaverProviderInstancePropertiesResponse): SapNetWeaverProviderInstancePropertiesResponse =
            SapNetWeaverProviderInstancePropertiesResponse(
                providerType = javaType.providerType(),
                sapClientId = javaType.sapClientId().map({ args0 -> args0 }).orElse(null),
                sapHostFileEntries = javaType.sapHostFileEntries().map({ args0 -> args0 }),
                sapHostname = javaType.sapHostname().map({ args0 -> args0 }).orElse(null),
                sapInstanceNr = javaType.sapInstanceNr().map({ args0 -> args0 }).orElse(null),
                sapPassword = javaType.sapPassword().map({ args0 -> args0 }).orElse(null),
                sapPasswordUri = javaType.sapPasswordUri().map({ args0 -> args0 }).orElse(null),
                sapPortNumber = javaType.sapPortNumber().map({ args0 -> args0 }).orElse(null),
                sapSid = javaType.sapSid().map({ args0 -> args0 }).orElse(null),
                sapUsername = javaType.sapUsername().map({ args0 -> args0 }).orElse(null),
                sslCertificateUri = javaType.sslCertificateUri().map({ args0 -> args0 }).orElse(null),
                sslPreference = javaType.sslPreference().map({ args0 -> args0 }).orElse(null),
            )
    }
}
