@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The resource names object for shared storage.
 * @property sharedStorageAccountName The full name of the shared storage account. If it is not provided, it will be defaulted to {SID}nfs{guid of 15 chars}.
 * @property sharedStorageAccountPrivateEndPointName The full name of private end point for the shared storage account. If it is not provided, it will be defaulted to {storageAccountName}_pe
 */
public data class SharedStorageResourceNamesResponse(
    public val sharedStorageAccountName: String? = null,
    public val sharedStorageAccountPrivateEndPointName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.SharedStorageResourceNamesResponse): SharedStorageResourceNamesResponse = SharedStorageResourceNamesResponse(
            sharedStorageAccountName = javaType.sharedStorageAccountName().map({ args0 -> args0 }).orElse(null),
            sharedStorageAccountPrivateEndPointName = javaType.sharedStorageAccountPrivateEndPointName().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
