@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The V2 policy schedule for IaaS that supports hourly backups.
 * @property dailySchedule Daily schedule of this policy
 * @property hourlySchedule hourly schedule of this policy
 * @property schedulePolicyType This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
 * Expected value is 'SimpleSchedulePolicyV2'.
 * @property scheduleRunFrequency Frequency of the schedule operation of this policy.
 * @property weeklySchedule Weekly schedule of this policy
 */
public data class SimpleSchedulePolicyV2Response(
    public val dailySchedule: DailyScheduleResponse? = null,
    public val hourlySchedule: HourlyScheduleResponse? = null,
    public val schedulePolicyType: String,
    public val scheduleRunFrequency: String? = null,
    public val weeklySchedule: WeeklyScheduleResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.SimpleSchedulePolicyV2Response): SimpleSchedulePolicyV2Response = SimpleSchedulePolicyV2Response(
            dailySchedule = javaType.dailySchedule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.DailyScheduleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hourlySchedule = javaType.hourlySchedule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.HourlyScheduleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            schedulePolicyType = javaType.schedulePolicyType(),
            scheduleRunFrequency = javaType.scheduleRunFrequency().map({ args0 -> args0 }).orElse(null),
            weeklySchedule = javaType.weeklySchedule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.WeeklyScheduleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
