@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The resource name object where the specified values will be full resource names of the corresponding resources in a single server SAP system.
 * @property namingPatternType The pattern type to be used for resource naming.
 * Expected value is 'FullResourceName'.
 * @property virtualMachine The resource names object for virtual machine and related resources.
 */
public data class SingleServerFullResourceNamesResponse(
    public val namingPatternType: String,
    public val virtualMachine: VirtualMachineResourceNamesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.SingleServerFullResourceNamesResponse): SingleServerFullResourceNamesResponse = SingleServerFullResourceNamesResponse(
            namingPatternType = javaType.namingPatternType(),
            virtualMachine = javaType.virtualMachine().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.VirtualMachineResourceNamesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
