@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress

/**
 * Defines the SQL Backup data for a virtual instance for SAP.
 * @property backupPolicy Defines the policy properties for database backup.
 * @property backupType The type of backup, VM, SQL or HANA.
 * Expected value is 'SQL'.
 * @property recoveryServicesVault The properties of the recovery services vault used for backup.
 */
public data class SqlBackupDataResponse(
    public val backupPolicy: DBBackupPolicyPropertiesResponse,
    public val backupType: String,
    public val recoveryServicesVault: Either<ExistingRecoveryServicesVaultResponse, NewRecoveryServicesVaultResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.SqlBackupDataResponse): SqlBackupDataResponse = SqlBackupDataResponse(
            backupPolicy = javaType.backupPolicy().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.DBBackupPolicyPropertiesResponse.Companion.toKotlin(args0)
            }),
            backupType = javaType.backupType(),
            recoveryServicesVault = javaType.recoveryServicesVault().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.workloads.kotlin.outputs.ExistingRecoveryServicesVaultResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.workloads.kotlin.outputs.NewRecoveryServicesVaultResponse.Companion.toKotlin(args0)
                    })
                },
            ),
        )
    }
}
