@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Contains information about SSH certificate public key and the path on the Linux VM where the public key is placed.
 * @property keyData SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
 */
public data class SshPublicKeyResponse(
    public val keyData: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.SshPublicKeyResponse): SshPublicKeyResponse = SshPublicKeyResponse(
            keyData = javaType.keyData().map({ args0 -> args0 }).orElse(null),
        )
    }
}
