@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Gets or sets the three tier SAP configuration. For prerequisites for creating the infrastructure, please see [here](https://go.microsoft.com/fwlink/?linkid=2212611&clcid=0x409)
 * @property appResourceGroup The application resource group where SAP system resources will be deployed.
 * @property applicationServer The application server configuration.
 * @property centralServer The central server configuration.
 * @property customResourceNames The set of custom names to be used for underlying azure resources that are part of the SAP system.
 * @property databaseServer The database configuration.
 * @property deploymentType The type of SAP deployment, single server or Three tier.
 * Expected value is 'ThreeTier'.
 * @property highAvailabilityConfig The high availability configuration.
 * @property networkConfiguration Network configuration common to all servers
 * @property storageConfiguration The storage configuration.
 */
public data class ThreeTierConfigurationResponse(
    public val appResourceGroup: String,
    public val applicationServer: ApplicationServerConfigurationResponse,
    public val centralServer: CentralServerConfigurationResponse,
    public val customResourceNames: ThreeTierFullResourceNamesResponse? = null,
    public val databaseServer: DatabaseConfigurationResponse,
    public val deploymentType: String,
    public val highAvailabilityConfig: HighAvailabilityConfigurationResponse? = null,
    public val networkConfiguration: NetworkConfigurationResponse? = null,
    public val storageConfiguration: StorageConfigurationResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.ThreeTierConfigurationResponse): ThreeTierConfigurationResponse = ThreeTierConfigurationResponse(
            appResourceGroup = javaType.appResourceGroup(),
            applicationServer = javaType.applicationServer().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.ApplicationServerConfigurationResponse.Companion.toKotlin(args0)
            }),
            centralServer = javaType.centralServer().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.CentralServerConfigurationResponse.Companion.toKotlin(args0)
            }),
            customResourceNames = javaType.customResourceNames().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.ThreeTierFullResourceNamesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            databaseServer = javaType.databaseServer().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.DatabaseConfigurationResponse.Companion.toKotlin(args0)
            }),
            deploymentType = javaType.deploymentType(),
            highAvailabilityConfig = javaType.highAvailabilityConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.HighAvailabilityConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            networkConfiguration = javaType.networkConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.NetworkConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageConfiguration = javaType.storageConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.StorageConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
