@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Tiering Policy for a target tier.
 * If the policy is not specified for a given target tier, service retains the existing configured tiering policy for that tier
 * @property duration Number of days/weeks/months/years to retain backups in current tier before tiering.
 * Used only if TieringMode is set to TierAfter
 * @property durationType Retention duration type: days/weeks/months/years
 * Used only if TieringMode is set to TierAfter
 * @property tieringMode Tiering Mode to control automatic tiering of recovery points. Supported values are:
 * 1. TierRecommended: Tier all recovery points recommended to be tiered
 * 2. TierAfter: Tier all recovery points after a fixed period, as specified in duration + durationType below.
 * 3. DoNotTier: Do not tier any recovery points
 */
public data class TieringPolicyResponse(
    public val duration: Int? = null,
    public val durationType: String? = null,
    public val tieringMode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.TieringPolicyResponse): TieringPolicyResponse = TieringPolicyResponse(
            duration = javaType.duration().map({ args0 -> args0 }).orElse(null),
            durationType = javaType.durationType().map({ args0 -> args0 }).orElse(null),
            tieringMode = javaType.tieringMode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
