@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Defines the policy properties for virtual machine backup.
 * @property backupManagementType This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
 * Expected value is 'AzureIaasVM'.
 * @property instantRPDetails Instant recovery point additional details.
 * @property instantRpRetentionRangeInDays Instant RP retention policy range in days
 * @property name The name of the VM Backup policy.
 * @property policyType The policy type.
 * @property protectedItemsCount Number of items associated with this policy.
 * @property resourceGuardOperationRequests ResourceGuard Operation Requests
 * @property retentionPolicy Retention policy with the details on backup copy retention ranges.
 * @property schedulePolicy Backup schedule specified as part of backup policy.
 * @property tieringPolicy Tiering policy to automatically move RPs to another tier
 * Key is Target Tier, defined in RecoveryPointTierType enum.
 * Tiering policy specifies the criteria to move RP to the target tier.
 * @property timeZone Time zone optional input as string. For example: "Pacific Standard Time".
 */
public data class VMBackupPolicyPropertiesResponse(
    public val backupManagementType: String,
    public val instantRPDetails: InstantRPAdditionalDetailsResponse? = null,
    public val instantRpRetentionRangeInDays: Int? = null,
    public val name: String,
    public val policyType: String? = null,
    public val protectedItemsCount: Int? = null,
    public val resourceGuardOperationRequests: List<String>? = null,
    public val retentionPolicy: Either<LongTermRetentionPolicyResponse, SimpleRetentionPolicyResponse>? = null,
    public val schedulePolicy: Any? = null,
    public val tieringPolicy: Map<String, TieringPolicyResponse>? = null,
    public val timeZone: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.VMBackupPolicyPropertiesResponse): VMBackupPolicyPropertiesResponse = VMBackupPolicyPropertiesResponse(
            backupManagementType = javaType.backupManagementType(),
            instantRPDetails = javaType.instantRPDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.InstantRPAdditionalDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            instantRpRetentionRangeInDays = javaType.instantRpRetentionRangeInDays().map({ args0 ->
                args0
            }).orElse(null),
            name = javaType.name(),
            policyType = javaType.policyType().map({ args0 -> args0 }).orElse(null),
            protectedItemsCount = javaType.protectedItemsCount().map({ args0 -> args0 }).orElse(null),
            resourceGuardOperationRequests = javaType.resourceGuardOperationRequests().map({ args0 -> args0 }),
            retentionPolicy = javaType.retentionPolicy().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.workloads.kotlin.outputs.LongTermRetentionPolicyResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.workloads.kotlin.outputs.SimpleRetentionPolicyResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            schedulePolicy = javaType.schedulePolicy().map({ args0 -> args0 }).orElse(null),
            tieringPolicy = javaType.tieringPolicy().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.workloads.kotlin.outputs.TieringPolicyResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            timeZone = javaType.timeZone().map({ args0 -> args0 }).orElse(null),
        )
    }
}
