@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Weekly retention format.
 * @property daysOfTheWeek List of days of the week.
 * @property weeksOfTheMonth List of weeks of month.
 */
public data class WeeklyRetentionFormatResponse(
    public val daysOfTheWeek: List<String>? = null,
    public val weeksOfTheMonth: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.WeeklyRetentionFormatResponse): WeeklyRetentionFormatResponse = WeeklyRetentionFormatResponse(
            daysOfTheWeek = javaType.daysOfTheWeek().map({ args0 -> args0 }),
            weeksOfTheMonth = javaType.weeksOfTheMonth().map({ args0 -> args0 }),
        )
    }
}
