@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Weekly schedule.
 * @property scheduleRunDays Schedule run days.
 * @property scheduleRunTimes List of times of day this schedule has to be run.
 */
public data class WeeklyScheduleResponse(
    public val scheduleRunDays: List<String>? = null,
    public val scheduleRunTimes: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.WeeklyScheduleResponse): WeeklyScheduleResponse = WeeklyScheduleResponse(
            scheduleRunDays = javaType.scheduleRunDays().map({ args0 -> args0 }),
            scheduleRunTimes = javaType.scheduleRunTimes().map({ args0 -> args0 }),
        )
    }
}
