@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies Windows operating system settings on the virtual machine.
 * @property osType The OS Type
 * Expected value is 'Windows'.
 */
public data class WindowsConfigurationResponse(
    public val osType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.WindowsConfigurationResponse): WindowsConfigurationResponse = WindowsConfigurationResponse(
            osType = javaType.osType(),
        )
    }
}
