/*
 * Decompiled with CFR 0.152.
 */
package scala.build;

import coursier.cache.FileCache;
import coursier.core.Repository;
import coursier.util.Task;
import dependency.CovariantSet;
import dependency.CovariantSet$;
import dependency.DependencyLike;
import dependency.DependencyLike$;
import dependency.ModuleLike;
import dependency.ModuleLike$;
import dependency.NameAttributes;
import dependency.NoAttributes$;
import dependency.ScalaParameters;
import dependency.ScalaParameters$;
import geny.Writable$;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.compress.archivers.zip.ZipFile;
import os.Path;
import os.PathChunk;
import os.PathChunk$;
import os.ReadablePath;
import os.RelPath$;
import os.Source;
import os.Source$;
import os.exists$;
import os.makeDir$;
import os.read$;
import os.write$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.build.Artifacts$;
import scala.build.Directories$;
import scala.build.EitherCps$;
import scala.build.Logger;
import scala.build.Positioned;
import scala.build.Positioned$;
import scala.build.ScalafixArtifacts;
import scala.build.errors.BuildException;
import scala.build.internal.Constants$;
import scala.build.internal.CsLoggerUtil;
import scala.build.internal.CsLoggerUtil$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.matching.Regex;

public final class ScalafixArtifacts$
implements Mirror.Product,
Serializable {
    public static final ScalafixArtifacts$ MODULE$ = new ScalafixArtifacts$();

    private ScalafixArtifacts$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ScalafixArtifacts$.class);
    }

    public ScalafixArtifacts apply(Seq<Path> scalafixJars, Seq<Path> toolsJars) {
        return new ScalafixArtifacts(scalafixJars, toolsJars);
    }

    public ScalafixArtifacts unapply(ScalafixArtifacts x$1) {
        return x$1;
    }

    public Either<BuildException, ScalafixArtifacts> artifacts(String scalaVersion, Seq<Positioned<DependencyLike<NameAttributes, NameAttributes>>> externalRulesDeps, Seq<Repository> extraRepositories, Logger logger, FileCache<Task> cache) {
        return EitherCps$.MODULE$.either().apply((Function1 & Serializable)evidence$1 -> {
            Properties scalafixProperties = (Properties)EitherCps$.MODULE$.value(evidence$1, MODULE$.fetchOrLoadScalafixProperties(extraRepositories, logger, cache));
            String key = (String)EitherCps$.MODULE$.value(evidence$1, MODULE$.scalafixPropsKey(scalaVersion));
            String fetchScalaVersion = scalafixProperties.getProperty(key);
            Seq scalafixDeps = (Seq)((SeqOps)new .colon.colon((Object)DependencyLike$.MODULE$.apply(ModuleLike$.MODULE$.apply("ch.epfl.scala", new StringBuilder(13).append("scalafix-cli_").append(ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{fetchScalaVersion, Constants$.MODULE$.scalafixVersion()}).apply(0).toString()).toString(), (NameAttributes)NoAttributes$.MODULE$, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))), new StringBuilder(0).append(ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{fetchScalaVersion, Constants$.MODULE$.scalafixVersion()}).apply(1).toString()).toString(), (CovariantSet)CovariantSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ModuleLike[0])), (Seq)((SeqOps)Nil$.MODULE$)), (List)Nil$.MODULE$));
            Seq scalafix = (Seq)EitherCps$.MODULE$.value(evidence$1, Artifacts$.MODULE$.artifacts((Seq)scalafixDeps.map((Function1 & Serializable)value -> Positioned$.MODULE$.none(value)), extraRepositories, (Option)None$.MODULE$, logger, CsLoggerUtil.CsCacheExtensions$.MODULE$.withMessage$extension(CsLoggerUtil$.MODULE$.CsCacheExtensions(cache), new StringBuilder(25).append("Downloading scalafix-cli ").append(Constants$.MODULE$.scalafixVersion()).toString()), Artifacts$.MODULE$.artifacts$default$6()));
            ScalaParameters scalaParameters = scalaVersion.startsWith("3") ? ScalaParameters$.MODULE$.apply(Constants$.MODULE$.defaultScala213Version()) : ScalaParameters$.MODULE$.apply(scalaVersion);
            Seq tools = (Seq)EitherCps$.MODULE$.value(evidence$1, Artifacts$.MODULE$.artifacts(externalRulesDeps, extraRepositories, (Option)Some$.MODULE$.apply((Object)scalaParameters), logger, CsLoggerUtil.CsCacheExtensions$.MODULE$.withMessage$extension(CsLoggerUtil$.MODULE$.CsCacheExtensions(cache), "Downloading scalafix.deps"), Artifacts$.MODULE$.artifacts$default$6()));
            return MODULE$.apply((Seq<Path>)((Seq)scalafix.map((Function1 & Serializable)_$1 -> (Path)_$1._2())), (Seq<Path>)((Seq)tools.map((Function1 & Serializable)_$2 -> (Path)_$2._2())));
        });
    }

    private Either<BuildException, Properties> fetchOrLoadScalafixProperties(Seq<Repository> extraRepositories, Logger logger, FileCache<Task> cache) {
        return EitherCps$.MODULE$.either().apply((Function1 & Serializable)evidence$2 -> {
            String string;
            String s$proxy1;
            Path cacheDir = Directories$.MODULE$.directories().cacheDir().$div((PathChunk)new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(PathChunk$.MODULE$.segmentsFromString("scalafix-props-cache"))));
            Path cachePath = cacheDir.$div((PathChunk)new PathChunk.StringPathChunk(s$proxy1 = new StringBuilder(31).append("scalafix-interfaces-").append(Constants$.MODULE$.scalafixVersion()).append(".properties").toString()));
            if (!exists$.MODULE$.apply(cachePath)) {
                Path interfacesJar = (Path)EitherCps$.MODULE$.value(evidence$2, MODULE$.fetchScalafixInterfaces(extraRepositories, logger, cache));
                String propsData = (String)EitherCps$.MODULE$.value(evidence$2, MODULE$.readScalafixProperties(interfacesJar));
                if (!exists$.MODULE$.apply(cacheDir)) {
                    makeDir$.MODULE$.apply(cacheDir);
                }
                write$.MODULE$.apply(cachePath, (Source)Source$.MODULE$.WritableSource((Object)propsData, (Function1 & Serializable)s -> Writable$.MODULE$.StringWritable(s)), write$.MODULE$.apply$default$3(), write$.MODULE$.apply$default$4());
                string = propsData;
            } else {
                string = read$.MODULE$.apply((ReadablePath)cachePath);
            }
            String content = string;
            Properties props = new Properties();
            ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes());
            props.load(stream);
            return props;
        });
    }

    private Either<BuildException, Path> fetchScalafixInterfaces(Seq<Repository> extraRepositories, Logger logger, FileCache<Task> cache) {
        return EitherCps$.MODULE$.either().apply((Function1 & Serializable)evidence$3 -> {
            DependencyLike scalafixInterfaces = DependencyLike$.MODULE$.apply(ModuleLike$.MODULE$.apply("ch.epfl.scala", "scalafix-interfaces", (NameAttributes)NoAttributes$.MODULE$, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))), new StringBuilder(0).append(ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Constants$.MODULE$.scalafixVersion()}).apply(0).toString()).toString(), (CovariantSet)CovariantSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ModuleLike[0])), (Seq)((SeqOps)Nil$.MODULE$));
            Seq fetchResult = (Seq)EitherCps$.MODULE$.value(evidence$3, Artifacts$.MODULE$.artifacts((Seq)((List)new .colon.colon((Object)scalafixInterfaces, (List)Nil$.MODULE$)).map((Function1 & Serializable)value -> Positioned$.MODULE$.none(value)), extraRepositories, (Option)None$.MODULE$, logger, CsLoggerUtil.CsCacheExtensions$.MODULE$.withMessage$extension(CsLoggerUtil$.MODULE$.CsCacheExtensions(cache), new StringBuilder(32).append("Downloading scalafix-interfaces ").append(scalafixInterfaces.version()).toString()), Artifacts$.MODULE$.artifacts$default$6()));
            String expectedJarName = new StringBuilder(24).append("scalafix-interfaces-").append(Constants$.MODULE$.scalafixVersion()).append(".jar").toString();
            Option interfacesJar = fetchResult.collectFirst((PartialFunction)new Serializable(expectedJarName){
                private final String expectedJarName$1;
                {
                    this.expectedJarName$1 = expectedJarName$2;
                }

                public final boolean isDefinedAt(Tuple2 x) {
                    Tuple2 tuple2 = x;
                    if (tuple2 != null) {
                        Path path = (Path)tuple2._2();
                        String string = path.last();
                        String string2 = this.expectedJarName$1;
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            return true;
                        }
                    }
                    return false;
                }

                public final Object applyOrElse(Tuple2 x, Function1 function1) {
                    Tuple2 tuple2 = x;
                    if (tuple2 != null) {
                        Path path = (Path)tuple2._2();
                        String string = path.last();
                        String string2 = this.expectedJarName$1;
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            return path;
                        }
                    }
                    return function1.apply((Object)x);
                }
            });
            return (Path)EitherCps$.MODULE$.value(evidence$3, interfacesJar.toRight(this::fetchScalafixInterfaces$$anonfun$1$$anonfun$1));
        });
    }

    private Either<BuildException, String> readScalafixProperties(Path jar) {
        ZipFile zipFile = new ZipFile(jar.toNIO());
        Option entry2 = CollectionConverters$.MODULE$.EnumerationHasAsScala(zipFile.getEntries()).asScala().find((Function1 & Serializable)entry -> {
            String string = entry.getName();
            String string2 = "scalafix-interfaces.properties";
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
        Either out = entry2.toRight(this::$anonfun$5).map((Function1 & Serializable)entry -> {
            InputStream stream = zipFile.getInputStream(entry);
            byte[] bytes = stream.readAllBytes();
            return new String(bytes);
        });
        zipFile.close();
        return out;
    }

    private Either<BuildException, String> scalafixPropsKey(String scalaVersion) {
        List list2;
        Option option;
        Regex regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\\d)\\.(\\d+).+"));
        String string = scalaVersion;
        if (string != null && !(option = regex.unapplySeq((CharSequence)string)).isEmpty() && (list2 = (List)option.get()).lengthCompare(2) == 0) {
            String string2 = (String)list2.apply(0);
            String string3 = (String)list2.apply(1);
            if ("2".equals(string2)) {
                if ("12".equals(string3)) {
                    return package$.MODULE$.Right().apply((Object)"scala212");
                }
                if ("13".equals(string3)) {
                    return package$.MODULE$.Right().apply((Object)"scala213");
                }
            }
            if ("3".equals(string2)) {
                String x = string3;
                if (StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x)) <= 3) {
                    return package$.MODULE$.Right().apply((Object)"scala3LTS");
                }
                return package$.MODULE$.Right().apply((Object)"scala3Next");
            }
        }
        return package$.MODULE$.Left().apply((Object)new BuildException(scalaVersion){});
    }

    public ScalafixArtifacts fromProduct(Product x$0) {
        return new ScalafixArtifacts((Seq<Path>)((Seq)x$0.productElement(0)), (Seq<Path>)((Seq)x$0.productElement(1)));
    }

    private final BuildException fetchScalafixInterfaces$$anonfun$1$$anonfun$1() {
        return new BuildException(){};
    }

    private final BuildException $anonfun$5() {
        return new BuildException(){};
    }
}

