/*
 * Decompiled with CFR 0.152.
 */
package scala.cli;

import bloop.rifle.FailedToStartServerException;
import caseapp.core.Error;
import coursier.Resolve$;
import coursier.jniutils.LoadWindowsLibrary;
import coursier.jniutils.WindowsAnsiTerminal;
import coursier.paths.Util;
import geny.Writable$;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Locale;
import java.util.Properties;
import java.util.zip.ZipException;
import os.Path;
import os.PathChunk;
import os.PathChunk$;
import os.ReadablePath;
import os.Source;
import os.Source$;
import os.exists$;
import os.isFile$;
import os.makeDir;
import os.read$;
import os.temp$;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.build.internal.Constants$;
import scala.cli.CurrentParams$;
import scala.cli.ScalaCliCommands;
import scala.cli.config.Key;
import scala.cli.config.Keys$;
import scala.cli.internal.Argv0;
import scala.cli.javaLauncher.JavaLauncherCli$;
import scala.cli.launcher.LauncherCli$;
import scala.cli.launcher.LauncherOptions;
import scala.cli.launcher.LauncherOptions$;
import scala.cli.publish.BouncycastleSignerMaker;
import scala.cli.util.ConfigDbUtils$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnce$;
import scala.collection.IterableOnceExtensionMethods$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Properties$;
import scala.util.Right;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public final class ScalaCli$
implements Serializable {
    public static final long OFFSET$_m_0;
    private static final String progName;
    private static final String scalaCliBinaryName;
    private static boolean isSipScala;
    private volatile Object javaMajorVersion$lzy1;
    public static final ScalaCli$ MODULE$;

    private ScalaCli$() {
    }

    static {
        String string;
        String name;
        Seq seq;
        Option option;
        String argv0;
        String last;
        String string2;
        OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ScalaCli$.class.getDeclaredField("javaMajorVersion$lzy1"));
        MODULE$ = new ScalaCli$();
        if (Properties$.MODULE$.isWin() && MODULE$.isGraalvmNativeImage()) {
            LoadWindowsLibrary.assumeInitialized();
        }
        progName = (string2 = (last = Paths.get(argv0 = new Argv0().get("scala-cli"), new String[0]).getFileName().toString())) != null && !(option = StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".", ".aux"})).s().unapplySeq(string2)).isEmpty() && (seq = (Seq)option.get()).lengthCompare(1) == 0 ? (name = (string = (String)seq.apply(0))) : argv0;
        scalaCliBinaryName = "scala-cli";
        LazyRef lazyRef = new LazyRef();
        Option isPowerEnv = Option$.MODULE$.apply((Object)System.getenv("SCALA_CLI_POWER")).flatMap((Function1 & Serializable)_$1 -> StringOps$.MODULE$.toBooleanOption$extension(Predef$.MODULE$.augmentString(_$1)));
        boolean isPower = BoxesRunTime.unboxToBoolean((Object)isPowerEnv.orElse(() -> MODULE$.$anonfun$2(lazyRef)).getOrElse(MODULE$::$anonfun$3));
        isSipScala = !isPower;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ScalaCli$.class);
    }

    public String progName() {
        return progName;
    }

    public boolean allowRestrictedFeatures() {
        return !isSipScala;
    }

    public String fullRunnerName() {
        if (this.progName().contains(scalaCliBinaryName)) {
            return "Scala CLI";
        }
        return "Scala code runner";
    }

    public String baseRunnerName() {
        if (this.progName().contains(scalaCliBinaryName)) {
            return scalaCliBinaryName;
        }
        return "scala";
    }

    private boolean isGraalvmNativeImage() {
        return scala.sys.package$.MODULE$.props().contains("org.graalvm.nativeimage.imagecode");
    }

    private Tuple2<String[], String[]> partitionArgs(String[] args) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])args);
        Object[] systemProps = (String[])ArrayOps$.MODULE$.takeWhile$extension(object, (Function1 & Serializable)_$2 -> _$2.startsWith("-D"));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])args);
        Object object3 = Predef$.MODULE$.refArrayOps(systemProps);
        return Tuple2$.MODULE$.apply((Object)systemProps, ArrayOps$.MODULE$.drop$extension(object2, ArrayOps$.MODULE$.size$extension(object3)));
    }

    private void setSystemProps(String[] systemProps) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])systemProps);
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$3 -> StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(_$3), "-D"), ClassTag$.MODULE$.apply(String.class)));
        ArrayOps$.MODULE$.foreach$extension(object2, (Function1 & Serializable)prop -> {
            String[] stringArray = prop.split("=", 2);
            if (stringArray != null) {
                Object object = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 2) == 0) {
                    String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                    String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
                    String key = string;
                    String value = string2;
                    return System.setProperty(key, value);
                }
                if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 1) == 0) {
                    String string;
                    String key = string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                    return System.setProperty(key, "");
                }
            }
            throw new MatchError((Object)stringArray);
        });
    }

    private void printThrowable(Throwable t, PrintStream out) {
        while (t != null) {
            out.println(t.toString());
            Object object = Predef$.MODULE$.refArrayOps((Object[])t.getStackTrace());
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)l -> out.println(new StringBuilder(2).append("  ").append(l).toString()));
            t = t.getCause();
        }
    }

    private byte[] printThrowable(Throwable t) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream((OutputStream)baos, true, StandardCharsets.UTF_8.name());
        this.printThrowable(t, ps);
        return baos.toByteArray();
    }

    private boolean isCI() {
        return System.getenv("CI") != null;
    }

    private boolean printStackTraces() {
        return Option$.MODULE$.apply((Object)System.getenv("SCALA_CLI_PRINT_STACK_TRACES")).map((Function1 & Serializable)_$4 -> _$4.toLowerCase(Locale.ROOT)).exists((Function1 & Serializable)x$1 -> {
            String string = x$1;
            return "true".equals(string) || "1".equals(string);
            {
            }
        });
    }

    private void ignoreSigpipe() {
        Signal.handle(new Signal("PIPE"), SignalHandler.SIG_IGN);
    }

    private boolean isJava17ClassName(String name) {
        String string = name;
        String string2 = "java/net/UnixDomainSocketAddress";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private int javaMajorVersion() {
        Object object = this.javaMajorVersion$lzy1;
        if (object instanceof Integer) {
            return BoxesRunTime.unboxToInt((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToInt(null);
        }
        return BoxesRunTime.unboxToInt((Object)this.javaMajorVersion$lzyINIT1());
    }

    private Object javaMajorVersion$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.javaMajorVersion$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Integer n = null;
                    try {
                        n = BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString((String)scala.sys.package$.MODULE$.props().getOrElse((Object)"java.version", this::javaMajorVersion$lzyINIT1$$anonfun$1)), "1.")), (Function1 & Serializable)_$5 -> this.javaMajorVersion$lzyINIT1$$anonfun$2(BoxesRunTime.unboxToChar((Object)_$5))))));
                        object2 = n == null ? LazyVals.NullValue$.MODULE$ : n;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.javaMajorVersion$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.javaMajorVersion$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return n;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void main(String[] args) {
        try {
            this.main0(args);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 == null) throw throwable;
            Throwable e = throwable3;
            if (this.isCI() || this.printStackTraces()) throw throwable;
            Path workspace = (Path)CurrentParams$.MODULE$.workspaceOpt().getOrElse(this::$anonfun$5);
            Path dir = workspace.$div((PathChunk)PathChunk$.MODULE$.StringPathChunk(Constants$.MODULE$.workspaceDirName())).$div((PathChunk)PathChunk$.MODULE$.StringPathChunk("stacktraces"));
            makeDir.all$.MODULE$.apply(dir);
            Path tempFile = temp$.MODULE$.apply((Source)Source$.MODULE$.WritableSource((Object)this.printThrowable(e), (Function1 & Serializable)a -> Writable$.MODULE$.ByteArrayWritable(a)), dir, new StringBuilder(1).append(BoxesRunTime.boxToLong((long)Instant.now().getEpochSecond()).toString()).append("-").toString(), ".log", false, temp$.MODULE$.apply$default$6());
            if (CurrentParams$.MODULE$.verbosity() <= 1) {
                System.err.println(new StringBuilder(7).append("Error: ").append(e).toString());
                System.err.println(new StringBuilder(31).append("For more details, please see '").append(tempFile).append("'").toString());
            }
            if ((throwable2 = e) instanceof UnsupportedClassVersionError && this.javaMajorVersion() < 17) {
                this.warnRequiresJava17();
            } else if (throwable2 instanceof NoClassDefFoundError && this.isJava17ClassName(e.getMessage()) && CurrentParams$.MODULE$.verbosity() <= 1 && this.javaMajorVersion() < 16) {
                this.warnRequiresJava17();
            } else if (throwable2 instanceof FailedToStartServerException) {
                System.err.println(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(84).append("Running\n                 |  ").append(this.progName()).append(" bloop output\n                 |might give more details.").toString())));
            } else if (throwable2 instanceof ZipException) {
                ZipException ex = (ZipException)throwable2;
                if (!Properties$.MODULE$.isWin() && ex.getMessage().contains("invalid entry CRC")) {
                    System.err.println(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(136).append("Running\n                 |  export SCALA_CLI_VENDORED_ZIS=true\n                 |before running ").append(this.fullRunnerName()).append(" might fix the issue.\n                 |").toString())));
                }
            }
            if (CurrentParams$.MODULE$.verbosity() < 2) throw scala.sys.package$.MODULE$.exit(1);
            throw e;
        }
    }

    private void warnRequiresJava17() {
        System.err.println(new StringBuilder(44).append("Java >= 17 is required to run ").append(this.fullRunnerName()).append(" (found Java ").append(this.javaMajorVersion()).append(")").toString());
    }

    public void loadJavaProperties(Path cwd) {
        Path jvmopts;
        Properties prop = new Properties();
        InputStream cl = this.getClass().getResourceAsStream("/java-properties/scala-cli-properties");
        if (cl != null) {
            prop.load(cl);
            prop.stringPropertyNames().forEach(name -> System.setProperty(name, prop.getProperty((String)name)));
        }
        if (exists$.MODULE$.apply(jvmopts = cwd.$div((PathChunk)PathChunk$.MODULE$.StringPathChunk(Constants$.MODULE$.jvmPropertiesFileName()))) && isFile$.MODULE$.apply(jvmopts)) {
            String jvmoptsContent = read$.MODULE$.apply((ReadablePath)jvmopts);
            Seq jvmoptsLines = StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(jvmoptsContent)).toSeq();
            Tuple2 tuple2 = jvmoptsLines.partition((Function1 & Serializable)_$6 -> _$6.startsWith("-D"));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq javaOpts = (Seq)tuple2._1();
            Seq otherOpts = (Seq)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)javaOpts, (Object)otherOpts);
            Seq javaOpts2 = (Seq)tuple22._1();
            Seq otherOpts2 = (Seq)tuple22._2();
            javaOpts2.foreach((Function1 & Serializable)opt -> {
                Object object;
                String[] stringArray = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(opt), "-D").split("=", 2);
                if (stringArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray), 2) == 0) {
                    String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                    String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
                    String key = string;
                    String value = string2;
                    return System.setProperty(key, value);
                }
                System.err.println(new StringBuilder(32).append("Warning: Invalid java property: ").append((String)opt).toString());
                return BoxedUnit.UNIT;
            });
            if (otherOpts2.nonEmpty()) {
                System.err.println(new StringBuilder(96).append("Warning: Only java properties are supported in .scala-jvmopts file. Other options are ignored: ").append(otherOpts2.mkString(", ")).append(" ").toString());
            }
        }
        ConfigDbUtils$.MODULE$.configDb().toOption().foreach((Function1)(JProcedure1 & Serializable)configDb -> {
            IterableOnce iterableOnce = IterableOnce$.MODULE$.iterableOnceExtensionMethods((IterableOnce)configDb.get((Key)Keys$.MODULE$.javaProperties()).getOrElse(this::loadJavaProperties$$anonfun$3$$anonfun$1));
            IterableOnceExtensionMethods$.MODULE$.foreach$extension(iterableOnce, (Function1)(JProcedure1 & Serializable)properties -> properties.foreach((Function1 & Serializable)opt -> {
                Object object;
                String[] stringArray = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(opt), "-D").split("=", 2);
                if (stringArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray), 2) == 0) {
                    String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                    String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
                    String key = string;
                    String value = string2;
                    return System.setProperty(key, value);
                }
                System.err.println(new StringBuilder(42).append("Warning: Invalid java property in config: ").append((String)opt).toString());
                return BoxedUnit.UNIT;
            }));
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void main0(String[] args) {
        Tuple2 tuple2;
        this.loadJavaProperties(os.package$.MODULE$.pwd());
        Either either = LauncherOptions$.MODULE$.parser().stopAtFirstUnrecognized().parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args).toVector());
        if (either instanceof Left) {
            Error e = (Error)((Left)either).value();
            System.err.println(e.message());
            throw scala.sys.package$.MODULE$.exit(1);
        }
        if (!(either instanceof Right) || (tuple2 = (Tuple2)((Right)either).value()) == null) throw new MatchError((Object)either);
        LauncherOptions launcherOpts = (LauncherOptions)tuple2._1();
        Seq args0 = (Seq)tuple2._2();
        Option option = launcherOpts.cliVersion().map((Function1 & Serializable)_$7 -> _$7.trim()).filter((Function1 & Serializable)_$8 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$8)));
        if (option instanceof Some) {
            String ver = (String)((Some)option).value();
            Nil$ powerArgs = launcherOpts.power() ? (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--power"})) : package$.MODULE$.Nil();
            Seq newArgs = (Seq)powerArgs.$plus$plus((IterableOnce)args0);
            throw LauncherCli$.MODULE$.runAndExit(ver, launcherOpts, (Seq<String>)newArgs);
        }
        if (this.javaMajorVersion() < 17 && scala.sys.package$.MODULE$.props().get("scala-cli.kind").exists((Function1 & Serializable)_$9 -> _$9.startsWith("jvm"))) {
            throw JavaLauncherCli$.MODULE$.runAndExit((Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)args));
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
        if (launcherOpts.power()) {
            isSipScala = false;
        }
        String[] remainingArgs = (String[])args0.toArray(ClassTag$.MODULE$.apply(String.class));
        Tuple2<String[], String[]> tuple22 = this.partitionArgs(remainingArgs);
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        String[] systemProps = (String[])tuple22._1();
        String[] scalaCliArgs = (String[])tuple22._2();
        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)systemProps, (Object)scalaCliArgs);
        String[] systemProps2 = (String[])tuple23._1();
        String[] scalaCliArgs2 = (String[])tuple23._2();
        this.setSystemProps(systemProps2);
        new BouncycastleSignerMaker().maybeInit();
        Resolve$.MODULE$.proxySetup();
        if (!Properties$.MODULE$.isWin() && this.isGraalvmNativeImage()) {
            this.ignoreSigpipe();
        }
        if (Properties$.MODULE$.isWin() && System.console() != null && Util.useJni()) {
            WindowsAnsiTerminal.enableAnsiOutput();
        }
        new ScalaCliCommands(this.progName(), this.baseRunnerName(), this.fullRunnerName(), isSipScala).main(scalaCliArgs2);
    }

    private final /* synthetic */ boolean isPowerConfigDb$lzyINIT1$1$$anonfun$1$$anonfun$1$$anonfun$1(boolean power) {
        return power;
    }

    private final Option isPowerConfigDb$lzyINIT1$1(LazyRef isPowerConfigDb$lzy1$1) {
        Option option;
        LazyRef lazyRef = isPowerConfigDb$lzy1$1;
        synchronized (lazyRef) {
            option = (Option)(isPowerConfigDb$lzy1$1.initialized() ? isPowerConfigDb$lzy1$1.value() : isPowerConfigDb$lzy1$1.initialize((Object)ConfigDbUtils$.MODULE$.configDb().toOption().flatMap((Function1 & Serializable)configDb -> configDb.get((Key)Keys$.MODULE$.power()).toOption().flatMap((Function1 & Serializable)powerEntry -> powerEntry.map((Function1 & Serializable)power -> this.isPowerConfigDb$lzyINIT1$1$$anonfun$1$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)power)))))));
        }
        return option;
    }

    private final Option isPowerConfigDb$1(LazyRef isPowerConfigDb$lzy1$2) {
        return (Option)(isPowerConfigDb$lzy1$2.initialized() ? isPowerConfigDb$lzy1$2.value() : this.isPowerConfigDb$lzyINIT1$1(isPowerConfigDb$lzy1$2));
    }

    private final Option $anonfun$2(LazyRef isPowerConfigDb$lzy1$3) {
        return this.isPowerConfigDb$1(isPowerConfigDb$lzy1$3);
    }

    private final boolean $anonfun$3() {
        return false;
    }

    private final String javaMajorVersion$lzyINIT1$$anonfun$1() {
        return "0";
    }

    private final /* synthetic */ boolean javaMajorVersion$lzyINIT1$$anonfun$2(char _$5) {
        return RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(_$5));
    }

    private final Path $anonfun$5() {
        return os.package$.MODULE$.pwd();
    }

    private final Object loadJavaProperties$$anonfun$3$$anonfun$1() {
        return package$.MODULE$.Nil();
    }
}

