/*
 * Decompiled with CFR 0.152.
 */
package scala.cli;

import caseapp.core.app.Command;
import caseapp.core.app.CommandsEntryPoint;
import caseapp.core.help.Help;
import caseapp.core.help.Help$;
import caseapp.core.help.HelpFormat;
import caseapp.core.help.RuntimeCommandsHelp;
import java.io.Serializable;
import java.nio.file.InvalidPathException;
import os.Path$;
import os.PathConvertible;
import os.ReadablePath;
import os.isFile$;
import os.read$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.cli.ScalaCli$;
import scala.cli.commands.HelpCmd;
import scala.cli.commands.NeedsArgvCommand;
import scala.cli.commands.ScalaCommand;
import scala.cli.commands.addpath.AddPath$;
import scala.cli.commands.bloop.Bloop$;
import scala.cli.commands.bloop.BloopExit$;
import scala.cli.commands.bloop.BloopOutput$;
import scala.cli.commands.bloop.BloopStart$;
import scala.cli.commands.bsp.Bsp$;
import scala.cli.commands.clean.Clean$;
import scala.cli.commands.compile.Compile$;
import scala.cli.commands.config.Config$;
import scala.cli.commands.default.Default;
import scala.cli.commands.default.DefaultFile$;
import scala.cli.commands.dependencyupdate.DependencyUpdate$;
import scala.cli.commands.directories.Directories$;
import scala.cli.commands.doc.Doc$;
import scala.cli.commands.export0.Export$;
import scala.cli.commands.fmt.Fmt$;
import scala.cli.commands.github.SecretCreate$;
import scala.cli.commands.github.SecretList$;
import scala.cli.commands.installcompletions.InstallCompletions$;
import scala.cli.commands.installhome.InstallHome$;
import scala.cli.commands.new.New$;
import scala.cli.commands.package0.Package$;
import scala.cli.commands.pgp.PgpCommands;
import scala.cli.commands.pgp.PgpCommandsSubst;
import scala.cli.commands.pgp.PgpPull$;
import scala.cli.commands.pgp.PgpPush$;
import scala.cli.commands.publish.Publish$;
import scala.cli.commands.publish.PublishLocal$;
import scala.cli.commands.publish.PublishSetup$;
import scala.cli.commands.repl.Repl$;
import scala.cli.commands.run.Run$;
import scala.cli.commands.setupide.SetupIde$;
import scala.cli.commands.shared.ScalaCliHelp$;
import scala.cli.commands.shebang.Shebang$;
import scala.cli.commands.test.Test$;
import scala.cli.commands.uninstall.Uninstall$;
import scala.cli.commands.uninstallcompletions.UninstallCompletions$;
import scala.cli.commands.update.Update$;
import scala.cli.commands.version.Version$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class ScalaCliCommands
extends CommandsEntryPoint {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(ScalaCliCommands.class.getDeclaredField("help$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(ScalaCliCommands.class.getDeclaredField("pgpUseBinaryCommands$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ScalaCliCommands.class.getDeclaredField("actualDefaultCommand$lzy1"));
    private final String progName;
    private final String baseRunnerName;
    private final String fullRunnerName;
    private final boolean isSipScala;
    private volatile Object actualDefaultCommand$lzy1;
    private volatile Object pgpUseBinaryCommands$lzy1;
    private volatile Object help$lzy1;

    public ScalaCliCommands(String progName, String baseRunnerName, String fullRunnerName, boolean isSipScala) {
        this.progName = progName;
        this.baseRunnerName = baseRunnerName;
        this.fullRunnerName = fullRunnerName;
        this.isSipScala = isSipScala;
    }

    public String progName() {
        return this.progName;
    }

    public Default actualDefaultCommand() {
        Object object = this.actualDefaultCommand$lzy1;
        if (object instanceof Default) {
            return (Default)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Default)this.actualDefaultCommand$lzyINIT1();
    }

    private Object actualDefaultCommand$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.actualDefaultCommand$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Default default_ = null;
                    try {
                        default_ = new Default((Function0<RuntimeCommandsHelp>)((Function0 & Serializable)this::actualDefaultCommand$lzyINIT1$$anonfun$1), this.isSipScala);
                        object2 = default_ == null ? LazyVals.NullValue$.MODULE$ : default_;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.actualDefaultCommand$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return default_;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private boolean pgpUseBinaryCommands() {
        Object object = this.pgpUseBinaryCommands$lzy1;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean((Object)this.pgpUseBinaryCommands$lzyINIT1());
    }

    private Object pgpUseBinaryCommands$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.pgpUseBinaryCommands$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Boolean bl = null;
                    try {
                        bl = BoxesRunTime.boxToBoolean((boolean)Boolean.getBoolean("scala-cli.pgp.binary-commands"));
                        object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.pgpUseBinaryCommands$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private PgpCommands pgpCommands() {
        return new PgpCommands();
    }

    private PgpCommandsSubst pgpBinaryCommands() {
        return new PgpCommandsSubst();
    }

    private Seq<Command<?>> allCommands() {
        Nil$ nil$;
        Nil$ nil$2;
        SeqOps seqOps = package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ScalaCommand[]{AddPath$.MODULE$, Bloop$.MODULE$, BloopExit$.MODULE$, BloopOutput$.MODULE$, BloopStart$.MODULE$, Bsp$.MODULE$, Clean$.MODULE$, Compile$.MODULE$, Config$.MODULE$, DefaultFile$.MODULE$, DependencyUpdate$.MODULE$, Directories$.MODULE$, Doc$.MODULE$, Export$.MODULE$, Fmt$.MODULE$, new HelpCmd((Function0<RuntimeCommandsHelp>)((Function0 & Serializable)this::allCommands$$anonfun$1)), InstallCompletions$.MODULE$, InstallHome$.MODULE$, New$.MODULE$, Repl$.MODULE$, Package$.MODULE$, PgpPull$.MODULE$, PgpPush$.MODULE$, Publish$.MODULE$, PublishLocal$.MODULE$, PublishSetup$.MODULE$, Run$.MODULE$, SecretCreate$.MODULE$, SecretList$.MODULE$, SetupIde$.MODULE$, Shebang$.MODULE$, Test$.MODULE$, Uninstall$.MODULE$, UninstallCompletions$.MODULE$, Update$.MODULE$, Version$.MODULE$}));
        if (this.pgpUseBinaryCommands()) {
            nil$2 = package$.MODULE$.Nil();
        } else {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.pgpCommands().allScalaCommands());
            nil$2 = ArrayOps$.MODULE$.toSeq$extension(object);
        }
        IterableOps iterableOps = (IterableOps)seqOps.$plus$plus((IterableOnce)nil$2);
        if (this.pgpUseBinaryCommands()) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.pgpBinaryCommands().allScalaCommands());
            nil$ = ArrayOps$.MODULE$.toSeq$extension(object);
        } else {
            nil$ = package$.MODULE$.Nil();
        }
        return (Seq)iterableOps.$plus$plus((IterableOnce)nil$);
    }

    public Seq<Command<?>> commands() {
        Nil$ nil$;
        Nil$ nil$2;
        Seq<Command<?>> seq = this.allCommands();
        if (this.pgpUseBinaryCommands()) {
            nil$2 = package$.MODULE$.Nil();
        } else {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.pgpCommands().allExternalCommands());
            nil$2 = ArrayOps$.MODULE$.toSeq$extension(object);
        }
        IterableOps iterableOps = (IterableOps)seq.$plus$plus((IterableOnce)nil$2);
        if (this.pgpUseBinaryCommands()) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.pgpBinaryCommands().allExternalCommands());
            nil$ = ArrayOps$.MODULE$.toSeq$extension(object);
        } else {
            nil$ = package$.MODULE$.Nil();
        }
        return (Seq)iterableOps.$plus$plus((IterableOnce)nil$);
    }

    public String description() {
        String coreFeaturesString = ScalaCli$.MODULE$.allowRestrictedFeatures() ? "compile, run, test and package" : "compile, run and test";
        return new StringBuilder(90).append(this.fullRunnerName).append(" is a command-line tool to interact with the Scala language. It lets you ").append(coreFeaturesString).append(" your Scala code.").toString();
    }

    public String summaryDesc() {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(341).append("|See '").append(this.baseRunnerName).append(" <command> --help' to read about a specific subcommand. To see full help run '").append(this.baseRunnerName).append(" <command> --help-full'.\n        |\n        |To use launcher options, specify them before any other argument.\n        |For example, to run another ").append(this.fullRunnerName).append(" version, specify it with the '--cli-version' launcher option:\n        |  ").append("\u001b[1m").append(this.baseRunnerName).append(" --cli-version <version> args").append("\u001b[0m").toString()));
    }

    public final Option<Command<?>> defaultCommand() {
        return Some$.MODULE$.apply((Object)this.actualDefaultCommand());
    }

    public RuntimeCommandsHelp help() {
        Object object = this.help$lzy1;
        if (object instanceof RuntimeCommandsHelp) {
            return (RuntimeCommandsHelp)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (RuntimeCommandsHelp)this.help$lzyINIT1();
    }

    private Object help$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.help$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    RuntimeCommandsHelp runtimeCommandsHelp = null;
                    try {
                        RuntimeCommandsHelp parent = super.help();
                        Help help = Help$.MODULE$.apply(Help$.MODULE$.$lessinit$greater$default$1(), Help$.MODULE$.$lessinit$greater$default$2(), Help$.MODULE$.$lessinit$greater$default$3(), Help$.MODULE$.$lessinit$greater$default$4(), Help$.MODULE$.$lessinit$greater$default$5(), Help$.MODULE$.$lessinit$greater$default$6(), Help$.MODULE$.$lessinit$greater$default$7(), Help$.MODULE$.$lessinit$greater$default$8());
                        String string = parent.copy$default$1();
                        Option option = parent.copy$default$2();
                        Seq seq = parent.copy$default$4();
                        Option option2 = parent.copy$default$5();
                        runtimeCommandsHelp = parent.copy(string, option, help, seq, option2);
                        object2 = runtimeCommandsHelp == null ? LazyVals.NullValue$.MODULE$ : runtimeCommandsHelp;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.help$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.help$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return runtimeCommandsHelp;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean enableCompleteCommand() {
        return true;
    }

    public boolean enableCompletionsCommand() {
        return true;
    }

    public HelpFormat helpFormat() {
        return ScalaCliHelp$.MODULE$.helpFormat();
    }

    private boolean isShebangFile(String arg) {
        None$ none$;
        try {
            none$ = Some$.MODULE$.apply((Object)Path$.MODULE$.apply((Object)arg, os.package$.MODULE$.pwd(), (PathConvertible)PathConvertible.StringConvertible$.MODULE$));
        }
        catch (InvalidPathException invalidPathException) {
            none$ = None$.MODULE$;
        }
        None$ pathOpt = none$;
        return pathOpt.filter((Function1 & Serializable)_$1 -> isFile$.MODULE$.apply(_$1)).filter((Function1 & Serializable)_$2 -> _$2.toIO().canRead()).exists((Function1 & Serializable)path -> {
            String content = read$.MODULE$.apply((ReadablePath)path);
            return content.startsWith(new StringBuilder(15).append("#!/usr/bin/env ").append(this.progName()).append(System.lineSeparator()).toString());
        });
    }

    public void main(String[] args) {
        String[] stringArray;
        this.actualDefaultCommand().rawArgs_$eq(args);
        this.commands().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Command command = x$1;
            if (command instanceof NeedsArgvCommand) {
                Command c = (Command)((NeedsArgvCommand)command);
                Object object = Predef$.MODULE$.refArrayOps((Object[])args);
                ((NeedsArgvCommand)c).setArgv((String[])ArrayOps$.MODULE$.$plus$colon$extension(object, (Object)this.progName(), ClassTag$.MODULE$.apply(String.class)));
                return;
            }
        });
        Object object = Predef$.MODULE$.refArrayOps((Object[])args);
        this.actualDefaultCommand().setArgv((String[])ArrayOps$.MODULE$.$plus$colon$extension(object, (Object)this.progName(), ClassTag$.MODULE$.apply(String.class)));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])args);
        if (ArrayOps$.MODULE$.lengthCompare$extension(object2, 1) > 0 && this.isShebangFile(args[0])) {
            Object object3 = Predef$.MODULE$.refArrayOps((Object[])new String[]{args[0], "--"});
            Object object4 = Predef$.MODULE$.refArrayOps((Object[])args);
            stringArray = (String[])ArrayOps$.MODULE$.$plus$plus$extension(object3, (Object)((String[])ArrayOps$.MODULE$.tail$extension(object4)), ClassTag$.MODULE$.apply(String.class));
        } else {
            stringArray = args;
        }
        String[] processedArgs = stringArray;
        super.main(processedArgs);
    }

    private final RuntimeCommandsHelp actualDefaultCommand$lzyINIT1$$anonfun$1() {
        return this.help();
    }

    private final RuntimeCommandsHelp allCommands$$anonfun$1() {
        return this.help();
    }
}

