/*
 * Decompiled with CFR 0.152.
 */
package scala.cli.commands;

import caseapp.HelpMessage$;
import caseapp.core.Error;
import caseapp.core.help.Help;
import caseapp.core.help.Help$;
import caseapp.core.help.RuntimeCommandsHelp;
import caseapp.core.parser.Parser;
import caseapp.core.util.CaseUtil$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.cli.commands.ScalaCommand;
import scala.cli.commands.default.LegacyScalaOptions;
import scala.cli.commands.default.LegacyScalaOptions$;
import scala.cli.commands.shared.HasGlobalOptions;
import scala.cli.commands.util.HelpUtils$;
import scala.cli.launcher.LauncherOptions;
import scala.cli.launcher.LauncherOptions$;
import scala.collection.StringOps$;
import scala.runtime.Nothing$;
import scala.sys.package$;
import scala.util.Either;

public abstract class ScalaCommandWithCustomHelp<T extends HasGlobalOptions>
extends ScalaCommand<T> {
    private final Function0<RuntimeCommandsHelp> actualHelp;

    public ScalaCommandWithCustomHelp(Function0<RuntimeCommandsHelp> actualHelp, Parser<T> myParser, Help<T> help) {
        this.actualHelp = actualHelp;
        super(myParser, help);
    }

    private Help<LauncherOptions> launcherHelp() {
        Parser<LauncherOptions> parser = LauncherOptions$.MODULE$.parser();
        String appName0 = "Launcher";
        String progName0 = (String)None$.MODULE$.getOrElse(() -> ScalaCommandWithCustomHelp.$anonfun$1(appName0));
        return Help$.MODULE$.apply(parser.args(), appName0, "", progName0, (Option)None$.MODULE$, Help$.MODULE$.DefaultOptionsDesc(), parser.defaultNameFormatter(), (Option)Some$.MODULE$.apply((Object)HelpMessage$.MODULE$.apply("Run another Scala CLI version", HelpMessage$.MODULE$.$lessinit$greater$default$2(), HelpMessage$.MODULE$.$lessinit$greater$default$3())));
    }

    private Help<LegacyScalaOptions> legacyScalaHelp() {
        Parser<LegacyScalaOptions> parser = LegacyScalaOptions$.MODULE$.parser();
        String appName0 = "LegacyScala";
        String progName0 = (String)None$.MODULE$.getOrElse(() -> ScalaCommandWithCustomHelp.$anonfun$2(appName0));
        return Help$.MODULE$.apply(parser.args(), appName0, "", progName0, (Option)None$.MODULE$, Help$.MODULE$.DefaultOptionsDesc(), parser.defaultNameFormatter(), (Option)None$.MODULE$);
    }

    public String customHelp(boolean showHidden) {
        String helpString = ((RuntimeCommandsHelp)this.actualHelp.apply()).help(this.helpFormat(), showHidden);
        String launcherHelpString = HelpUtils$.MODULE$.optionsHelp(this.launcherHelp(), this.helpFormat(), showHidden);
        String legacyScalaHelpString = HelpUtils$.MODULE$.optionsHelp(this.legacyScalaHelp(), this.helpFormat(), showHidden);
        String legacyScalaHelpStringWithPadding = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(legacyScalaHelpString)) ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(26).append("\n           |").append(legacyScalaHelpString).append("\n           |").toString())) : "";
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(27).append(helpString).append("\n       |\n       |").append(launcherHelpString).append("\n       |").append(legacyScalaHelpStringWithPadding).toString()));
    }

    public Nothing$ customHelpAsked(boolean showHidden) {
        Predef$.MODULE$.println((Object)this.customHelp(showHidden));
        return package$.MODULE$.exit(0);
    }

    public Nothing$ helpAsked(String progName, Either<Error, T> maybeOptions) {
        return this.customHelpAsked(false);
    }

    public Nothing$ fullHelpAsked(String progName) {
        return this.customHelpAsked(true);
    }

    private static final String $anonfun$1(String appName0$1) {
        return CaseUtil$.MODULE$.pascalCaseSplit(Predef$.MODULE$.wrapString(appName0$1).toList()).map((Function1 & Serializable)_$6 -> _$6.toLowerCase()).mkString("-");
    }

    private static final String $anonfun$2(String appName0$2) {
        return CaseUtil$.MODULE$.pascalCaseSplit(Predef$.MODULE$.wrapString(appName0$2).toList()).map((Function1 & Serializable)_$6 -> _$6.toLowerCase()).mkString("-");
    }
}

