/*
 * Decompiled with CFR 0.152.
 */
package scala.cli.commands.publish.checks;

import java.io.Serializable;
import os.Path;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.build.Logger;
import scala.build.errors.BuildException;
import scala.build.options.PublishOptions;
import scala.cli.commands.publish.GitRepo$;
import scala.cli.commands.publish.GitRepoError;
import scala.cli.commands.publish.OptionCheck;
import scala.cli.commands.publish.OptionCheck$DefaultValue$;
import scala.cli.commands.publish.OptionCheck$Kind$Core$;
import scala.cli.commands.publish.PublishSetupOptions;
import scala.cli.commands.publish.SetSecret;
import scala.cli.commands.publish.checks.OrganizationCheck$;
import scala.cli.errors.MissingPublishOptionError;
import scala.cli.errors.MissingPublishOptionError$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class OrganizationCheck
implements OptionCheck,
Product,
Serializable {
    private final PublishSetupOptions options;
    private final Path workspace;
    private final Logger logger;

    public static OrganizationCheck apply(PublishSetupOptions publishSetupOptions, Path path, Logger logger) {
        return OrganizationCheck$.MODULE$.apply(publishSetupOptions, path, logger);
    }

    public static OrganizationCheck fromProduct(Product product) {
        return OrganizationCheck$.MODULE$.fromProduct(product);
    }

    public static OrganizationCheck unapply(OrganizationCheck organizationCheck) {
        return OrganizationCheck$.MODULE$.unapply(organizationCheck);
    }

    public OrganizationCheck(PublishSetupOptions options, Path workspace, Logger logger) {
        this.options = options;
        this.workspace = workspace;
        this.logger = logger;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof OrganizationCheck)) return false;
        OrganizationCheck organizationCheck = (OrganizationCheck)object;
        PublishSetupOptions publishSetupOptions = this.options();
        PublishSetupOptions publishSetupOptions2 = organizationCheck.options();
        if (publishSetupOptions == null) {
            if (publishSetupOptions2 != null) {
                return false;
            }
        } else if (!((Object)publishSetupOptions).equals(publishSetupOptions2)) return false;
        Path path = this.workspace();
        Path path2 = organizationCheck.workspace();
        if (path == null) {
            if (path2 != null) {
                return false;
            }
        } else if (!path.equals(path2)) return false;
        Logger logger = this.logger();
        Logger logger2 = organizationCheck.logger();
        if (logger == null) {
            if (logger2 == null) return true;
            return false;
        } else {
            if (!logger.equals(logger2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof OrganizationCheck;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "OrganizationCheck";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "options";
            }
            case 1: {
                return "workspace";
            }
            case 2: {
                return "logger";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public PublishSetupOptions options() {
        return this.options;
    }

    public Path workspace() {
        return this.workspace;
    }

    public Logger logger() {
        return this.logger;
    }

    @Override
    public OptionCheck.Kind kind() {
        return OptionCheck$Kind$Core$.MODULE$;
    }

    @Override
    public String fieldName() {
        return "organization";
    }

    @Override
    public String directivePath() {
        return "publish.organization";
    }

    @Override
    public boolean check(PublishOptions options) {
        return options.organization().nonEmpty();
    }

    @Override
    public Either<BuildException, OptionCheck.DefaultValue> defaultValue(PublishOptions pubOpt) {
        Option orgOpt = this.options().publishParams().organization().orElse(this::$anonfun$1);
        return orgOpt.map((Function1 & Serializable)_$1 -> OptionCheck$DefaultValue$.MODULE$.simple((String)_$1, (Seq<Tuple2<String, String>>)package$.MODULE$.Nil(), (Seq<SetSecret>)package$.MODULE$.Nil())).toRight(OrganizationCheck::defaultValue$$anonfun$2);
    }

    public OrganizationCheck copy(PublishSetupOptions options, Path workspace, Logger logger) {
        return new OrganizationCheck(options, workspace, logger);
    }

    public PublishSetupOptions copy$default$1() {
        return this.options();
    }

    public Path copy$default$2() {
        return this.workspace();
    }

    public Logger copy$default$3() {
        return this.logger();
    }

    public PublishSetupOptions _1() {
        return this.options();
    }

    public Path _2() {
        return this.workspace();
    }

    public Logger _3() {
        return this.logger();
    }

    private static final String viaGitHubRemoteOpt$1$$anonfun$1(GitRepoError err$1) {
        return new StringBuilder(93).append("Error when trying to get GitHub repo from git to compute default organization: ").append((Object)err$1).append(", ignoring it.").toString();
    }

    private static final String viaGitHubRemoteOpt$1$$anonfun$2() {
        return "organization:";
    }

    private static final String viaGitHubRemoteOpt$1$$anonfun$3(String org$1, String publishOrg$1) {
        return new StringBuilder(32).append("  computed ").append(publishOrg$1).append(" from GitHub account ").append(org$1).toString();
    }

    private final Option viaGitHubRemoteOpt$1() {
        Tuple2 tuple2;
        Either<GitRepoError, Tuple2<String, String>> either = GitRepo$.MODULE$.ghRepoOrgName(this.workspace(), this.logger());
        if (either instanceof Left) {
            GitRepoError err = (GitRepoError)((Object)((Left)either).value());
            this.logger().debug(() -> OrganizationCheck.viaGitHubRemoteOpt$1$$anonfun$1(err));
            return None$.MODULE$;
        }
        if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
            String org = (String)tuple2._1();
            String publishOrg = new StringBuilder(10).append("io.github.").append(org).toString();
            this.logger().message(OrganizationCheck::viaGitHubRemoteOpt$1$$anonfun$2);
            this.logger().message(() -> OrganizationCheck.viaGitHubRemoteOpt$1$$anonfun$3(org, publishOrg));
            return Some$.MODULE$.apply((Object)publishOrg);
        }
        throw new MatchError(either);
    }

    private final Option $anonfun$1() {
        return this.viaGitHubRemoteOpt$1();
    }

    private static final MissingPublishOptionError defaultValue$$anonfun$2() {
        return new MissingPublishOptionError("organization", "--organization", "publish.organization", MissingPublishOptionError$.MODULE$.$lessinit$greater$default$4(), MissingPublishOptionError$.MODULE$.$lessinit$greater$default$5());
    }
}

