/*
 * Decompiled with CFR 0.152.
 */
package scala.cli.packaging;

import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileTime;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import os.Path;
import os.PathChunk;
import os.PathChunk$;
import os.PermSet;
import os.ReadablePath;
import os.isFile$;
import os.mtime$;
import os.read;
import os.walk$;
import os.write$;
import scala.Function1;
import scala.Int$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.build.Build;
import scala.cli.internal.CachedBinary;
import scala.cli.internal.CachedBinary$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Library$
implements Serializable {
    public static final Library$ MODULE$ = new Library$();

    private Library$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Library$.class);
    }

    public Path libraryJar(Build.Successful build, Option<String> mainClassOpt) {
        Path workDir = build.inputs().libraryJarWorkDir();
        Path dest = workDir.$div((PathChunk)PathChunk$.MODULE$.StringPathChunk("library.jar"));
        CachedBinary.CacheData cacheData = CachedBinary$.MODULE$.getCacheData(build, (List<String>)mainClassOpt.toList().flatMap((Function1 & Serializable)c -> (IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--main-class", c}))), dest, workDir);
        if (cacheData.changed()) {
            try (OutputStream outputStream = null;){
                Seq seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StandardOpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING}));
                PermSet permSet = write$.MODULE$.outputStream$default$2();
                outputStream = write$.MODULE$.outputStream(dest, permSet, true, seq);
                this.writeLibraryJarTo(outputStream, build, mainClassOpt, this.writeLibraryJarTo$default$4(), this.writeLibraryJarTo$default$5());
            }
            CachedBinary$.MODULE$.updateProjectAndOutputSha(dest, workDir, cacheData.projectSha());
        }
        return dest;
    }

    public Option<String> libraryJar$default$2() {
        return None$.MODULE$;
    }

    public void writeLibraryJarTo(OutputStream outputStream, Build.Successful build, Option<String> mainClassOpt, boolean hasActualManifest, Option<Path> contentDirOverride) {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        if (hasActualManifest) {
            mainClassOpt.orElse(() -> this.writeLibraryJarTo$$anonfun$1(build)).withFilter((Function1 & Serializable)mainClass -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(mainClass))).foreach((Function1 & Serializable)mainClass -> manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, mainClass));
        }
        ObjectRef zos = ObjectRef.create(null);
        Path contentDir = (Path)contentDirOverride.getOrElse(() -> this.$anonfun$2(build));
        try {
            JarOutputStream jarOutputStream = new JarOutputStream(outputStream, manifest);
            zos.elem = jarOutputStream;
            jarOutputStream = null;
            walk$.MODULE$.apply(contentDir, walk$.MODULE$.apply$default$2(), walk$.MODULE$.apply$default$3(), walk$.MODULE$.apply$default$4(), walk$.MODULE$.apply$default$5(), walk$.MODULE$.apply$default$6()).withFilter((Function1 & Serializable)path -> isFile$.MODULE$.apply(path)).foreach((Function1)(JProcedure1 & Serializable)path -> {
                String name = path.relativeTo(contentDir).toString();
                long lastModified = mtime$.MODULE$.apply(path);
                ZipEntry ent = new ZipEntry(name);
                ent.setLastModifiedTime(FileTime.fromMillis(lastModified));
                byte[] content = read.bytes$.MODULE$.apply((ReadablePath)path);
                ent.setSize(Int$.MODULE$.int2long(content.length));
                ((ZipOutputStream)zos$1.elem).putNextEntry(ent);
                ((ZipOutputStream)zos$1.elem).write(content);
                ((ZipOutputStream)zos$1.elem).closeEntry();
            });
        }
        finally {
            if ((ZipOutputStream)zos.elem != null) {
                ((ZipOutputStream)zos.elem).close();
            }
        }
    }

    public Option<String> writeLibraryJarTo$default$3() {
        return None$.MODULE$;
    }

    public boolean writeLibraryJarTo$default$4() {
        return true;
    }

    public Option<Path> writeLibraryJarTo$default$5() {
        return None$.MODULE$;
    }

    public Seq<Path> fullClassPathAsJar(Build.Successful build) {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[]{this.libraryJar(build, this.libraryJar$default$2())})).$plus$plus((IterableOnce)build.dependencyClassPath());
    }

    public Seq<Path> fullClassPathMaybeAsJar(Build.Successful build, boolean asJar) {
        if (asJar) {
            return this.fullClassPathAsJar(build);
        }
        return build.fullClassPath();
    }

    private final Option writeLibraryJarTo$$anonfun$1(Build.Successful build$1) {
        return build$1.sources().defaultMainClass();
    }

    private final Path $anonfun$2(Build.Successful build$2) {
        return build$2.output();
    }
}

