/*
 * Decompiled with CFR 0.152.
 */
package scala.cli.commands.publish;

import java.io.File;
import java.io.Serializable;
import java.nio.file.attribute.UserPrincipal;
import org.eclipse.jgit.api.Git;
import os.Path;
import os.PathChunk;
import os.PathChunk$;
import os.isDir$;
import os.owner$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.build.Logger;
import scala.cli.commands.publish.GitRepoError;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Properties$;
import scala.util.Using;
import scala.util.Using$;
import scala.util.matching.Regex;

public final class GitRepo$
implements Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(GitRepo$.class.getDeclaredField("user$lzy1"));
    private volatile Object user$lzy1;
    public static final GitRepo$ MODULE$ = new GitRepo$();

    private GitRepo$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GitRepo$.class);
    }

    private UserPrincipal user() {
        Object object = this.user$lzy1;
        if (object instanceof UserPrincipal) {
            return (UserPrincipal)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (UserPrincipal)this.user$lzyINIT1();
    }

    private Object user$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.user$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    UserPrincipal userPrincipal = null;
                    try {
                        userPrincipal = owner$.MODULE$.apply(os.package$.MODULE$.home());
                        object2 = userPrincipal == null ? LazyVals.NullValue$.MODULE$ : userPrincipal;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.user$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return userPrincipal;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private boolean trusted(Path path) {
        if (Properties$.MODULE$.isWin()) {
            return path.toIO().canWrite();
        }
        UserPrincipal userPrincipal = owner$.MODULE$.apply(path);
        UserPrincipal userPrincipal2 = this.user();
        return !(userPrincipal != null ? !userPrincipal.equals(userPrincipal2) : userPrincipal2 != null);
    }

    public Option<Path> gitRepoOpt(Path workspace) {
        while (this.trusted(workspace)) {
            if (isDir$.MODULE$.apply(workspace.$div((PathChunk)PathChunk$.MODULE$.StringPathChunk(".git")))) {
                return Some$.MODULE$.apply((Object)workspace);
            }
            if (workspace.segmentCount() > 0) {
                workspace = workspace.$div((PathChunk)PathChunk$.MODULE$.RelPathChunk(os.package$.MODULE$.up()));
                continue;
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public Either<GitRepoError, Tuple2<String, String>> ghRepoOrgName(Path workspace, Logger logger) {
        Option<Path> option = this.gitRepoOpt(workspace);
        if (option instanceof Some) {
            Path repo = (Path)((Some)option).value();
            Seq<Tuple2<String, Tuple2<String, String>>> seq = this.remotes(repo, logger);
            if (seq != null) {
                Tuple2 tuple2;
                SeqOps seqOps = package$.MODULE$.Seq().unapplySeq(seq);
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 0) == 0) {
                    return package$.MODULE$.Left().apply((Object)new GitRepoError(new StringBuilder(50).append("Cannot determine GitHub organization and name for ").append(workspace).toString()));
                }
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 1) == 0 && (tuple2 = (Tuple2)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0)) != null) {
                    Tuple2 orgName = (Tuple2)tuple2._2();
                    return package$.MODULE$.Right().apply((Object)orgName);
                }
            }
            Seq<Tuple2<String, Tuple2<String, String>>> more = seq;
            Map map = more.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            return map.get((Object)"upstream").orElse(() -> this.ghRepoOrgName$$anonfun$1(map)).toRight(() -> this.ghRepoOrgName$$anonfun$2(workspace));
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)new GitRepoError(new StringBuilder(27).append(workspace).append(" is not in a git repository").toString()));
        }
        throw new MatchError(option);
    }

    private Seq<Tuple2<String, Tuple2<String, String>>> remotes(Path repo, Logger logger) {
        Buffer remoteList = (Buffer)Using$.MODULE$.resource((Object)Git.open((File)repo.toIO()), (Function1 & Serializable)git -> CollectionConverters$.MODULE$.ListHasAsScala(git.remoteList().call()).asScala(), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        logger.debug(() -> this.remotes$$anonfun$1(remoteList, repo));
        return remoteList.iterator().flatMap((Function1 & Serializable)remote -> {
            String name = remote.getName();
            return CollectionConverters$.MODULE$.ListHasAsScala(remote.getURIs()).asScala().iterator().map((Function1 & Serializable)_$1 -> _$1.toASCIIString()).flatMap((Function1 & Serializable)uri -> this.maybeGhOrgName((String)uri)).map((Function1 & Serializable)_$2 -> Tuple2$.MODULE$.apply((Object)name, _$2));
        }).toVector();
    }

    public Option<Tuple2<String, String>> maybeGhRepoOrgName(Path workspace, Logger logger) {
        return this.gitRepoOpt(workspace).flatMap((Function1 & Serializable)repo -> {
            Seq<Tuple2<String, Tuple2<String, String>>> more;
            Map map;
            Option res;
            Seq<Tuple2<String, Tuple2<String, String>>> seq = this.remotes((Path)repo, logger);
            if (seq != null) {
                Tuple2 tuple2;
                SeqOps seqOps = package$.MODULE$.Seq().unapplySeq(seq);
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 0) == 0) {
                    logger.debug(() -> this.maybeGhRepoOrgName$$anonfun$1$$anonfun$1(workspace));
                    return None$.MODULE$;
                }
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 1) == 0 && (tuple2 = (Tuple2)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0)) != null) {
                    Tuple2 orgName = (Tuple2)tuple2._2();
                    return Some$.MODULE$.apply((Object)orgName);
                }
            }
            if ((res = (map = (more = seq).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).get((Object)"upstream").orElse(() -> this.$anonfun$2(map))).isEmpty()) {
                new GitRepoError(new StringBuilder(58).append("Cannot determine default GitHub organization and name for ").append(workspace).toString());
            }
            return res;
        });
    }

    public Option<Tuple2<String, String>> maybeGhOrgName(String uri) {
        Regex httpsPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("https://github.com/(.+)/(.+).git"));
        Regex sshPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("git@github.com:(.+)/(.+).git"));
        String string = uri;
        if (string != null) {
            List list;
            List list2;
            Option option = httpsPattern.unapplySeq((CharSequence)string);
            if (!option.isEmpty() && (list2 = (List)option.get()).lengthCompare(2) == 0) {
                String string2 = (String)list2.apply(0);
                String string3 = (String)list2.apply(1);
                String org = string2;
                String name = string3;
                return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)org, (Object)name));
            }
            Option option2 = sshPattern.unapplySeq((CharSequence)string);
            if (!option2.isEmpty() && (list = (List)option2.get()).lengthCompare(2) == 0) {
                String string4 = (String)list.apply(0);
                String string5 = (String)list.apply(1);
                String org = string4;
                String name = string5;
                return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)org, (Object)name));
            }
        }
        return None$.MODULE$;
    }

    private final Option ghRepoOrgName$$anonfun$1(Map map$1) {
        return map$1.get((Object)"origin");
    }

    private final GitRepoError ghRepoOrgName$$anonfun$2(Path workspace$1) {
        return new GitRepoError(new StringBuilder(58).append("Cannot determine default GitHub organization and name for ").append(workspace$1).toString());
    }

    private final String remotes$$anonfun$1(Buffer remoteList$1, Path repo$1) {
        return new StringBuilder(27).append("Found ").append(remoteList$1.length()).append(" remotes in Git repo ").append(repo$1).toString();
    }

    private final String maybeGhRepoOrgName$$anonfun$1$$anonfun$1(Path workspace$3) {
        return new StringBuilder(26).append("No GitHub remote found in ").append(workspace$3).toString();
    }

    private final Option $anonfun$2(Map map$2) {
        return map$2.get((Object)"origin");
    }
}

