/*
 * Decompiled with CFR 0.152.
 */
package scala.cli.commands.publish.checks;

import java.io.Serializable;
import os.Path;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.build.Logger;
import scala.build.errors.BuildException;
import scala.build.options.PublishOptions;
import scala.cli.commands.publish.GitRepo$;
import scala.cli.commands.publish.OptionCheck;
import scala.cli.commands.publish.OptionCheck$DefaultValue$;
import scala.cli.commands.publish.OptionCheck$Kind$Core$;
import scala.cli.commands.publish.PublishSetupOptions;
import scala.cli.commands.publish.SetSecret;
import scala.cli.commands.publish.checks.ComputeVersionCheck$;
import scala.cli.errors.MissingPublishOptionError;
import scala.cli.errors.MissingPublishOptionError$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class ComputeVersionCheck
implements OptionCheck,
Product,
Serializable {
    private final PublishSetupOptions options;
    private final Path workspace;
    private final Logger logger;

    public static ComputeVersionCheck apply(PublishSetupOptions publishSetupOptions, Path path, Logger logger) {
        return ComputeVersionCheck$.MODULE$.apply(publishSetupOptions, path, logger);
    }

    public static ComputeVersionCheck fromProduct(Product product) {
        return ComputeVersionCheck$.MODULE$.fromProduct(product);
    }

    public static ComputeVersionCheck unapply(ComputeVersionCheck computeVersionCheck) {
        return ComputeVersionCheck$.MODULE$.unapply(computeVersionCheck);
    }

    public ComputeVersionCheck(PublishSetupOptions options, Path workspace, Logger logger) {
        this.options = options;
        this.workspace = workspace;
        this.logger = logger;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ComputeVersionCheck)) return false;
        ComputeVersionCheck computeVersionCheck = (ComputeVersionCheck)object;
        PublishSetupOptions publishSetupOptions = this.options();
        PublishSetupOptions publishSetupOptions2 = computeVersionCheck.options();
        if (publishSetupOptions == null) {
            if (publishSetupOptions2 != null) {
                return false;
            }
        } else if (!((Object)publishSetupOptions).equals(publishSetupOptions2)) return false;
        Path path = this.workspace();
        Path path2 = computeVersionCheck.workspace();
        if (path == null) {
            if (path2 != null) {
                return false;
            }
        } else if (!path.equals(path2)) return false;
        Logger logger = this.logger();
        Logger logger2 = computeVersionCheck.logger();
        if (logger == null) {
            if (logger2 == null) return true;
            return false;
        } else {
            if (!logger.equals(logger2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ComputeVersionCheck;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "ComputeVersionCheck";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "options";
            }
            case 1: {
                return "workspace";
            }
            case 2: {
                return "logger";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public PublishSetupOptions options() {
        return this.options;
    }

    public Path workspace() {
        return this.workspace;
    }

    public Logger logger() {
        return this.logger;
    }

    @Override
    public OptionCheck.Kind kind() {
        return OptionCheck$Kind$Core$.MODULE$;
    }

    @Override
    public String fieldName() {
        return "computeVersion";
    }

    @Override
    public String directivePath() {
        return new StringBuilder(22).append("publish").append(this.options().publishParams().setupCi() ? ".ci" : "").append(".computeVersion").toString();
    }

    @Override
    public boolean check(PublishOptions pubOpt) {
        return pubOpt.version().nonEmpty() || pubOpt.retained(this.options().publishParams().setupCi()).computeVersion().nonEmpty();
    }

    @Override
    public Either<BuildException, OptionCheck.DefaultValue> defaultValue(PublishOptions pubOpt) {
        Option cv = this.options().sharedVersionOptions().computeVersion().orElse(this::$anonfun$1);
        return cv.map((Function1 & Serializable)_$1 -> OptionCheck$DefaultValue$.MODULE$.simple((String)_$1, (Seq<Tuple2<String, String>>)package$.MODULE$.Nil(), (Seq<SetSecret>)package$.MODULE$.Nil())).toRight(ComputeVersionCheck::defaultValue$$anonfun$2);
    }

    public ComputeVersionCheck copy(PublishSetupOptions options, Path workspace, Logger logger) {
        return new ComputeVersionCheck(options, workspace, logger);
    }

    public PublishSetupOptions copy$default$1() {
        return this.options();
    }

    public Path copy$default$2() {
        return this.workspace();
    }

    public Logger copy$default$3() {
        return this.logger();
    }

    public PublishSetupOptions _1() {
        return this.options();
    }

    public Path _2() {
        return this.workspace();
    }

    public Logger _3() {
        return this.logger();
    }

    private static final String fromGitOpt$1$$anonfun$1() {
        return "computeVersion:";
    }

    private static final String fromGitOpt$1$$anonfun$2() {
        return "  assuming versions are computed from git tags";
    }

    private final Option fromGitOpt$1() {
        if (GitRepo$.MODULE$.gitRepoOpt(this.workspace()).isDefined()) {
            this.logger().message(ComputeVersionCheck::fromGitOpt$1$$anonfun$1);
            this.logger().message(ComputeVersionCheck::fromGitOpt$1$$anonfun$2);
            return Some$.MODULE$.apply((Object)"git:tag");
        }
        return None$.MODULE$;
    }

    private final Option $anonfun$1() {
        return this.fromGitOpt$1();
    }

    private static final MissingPublishOptionError defaultValue$$anonfun$2() {
        return new MissingPublishOptionError("compute version", "--compute-version", "publish.computeVersion", MissingPublishOptionError$.MODULE$.$lessinit$greater$default$4(), MissingPublishOptionError$.MODULE$.$lessinit$greater$default$5());
    }
}

