/*
 * Decompiled with CFR 0.152.
 */
package scala.cli.commands.version;

import caseapp.core.RemainingArgs;
import caseapp.core.help.HelpFormat;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.build.Logger;
import scala.build.errors.CheckScalaCliVersionError;
import scala.build.internal.Constants$;
import scala.cli.ScalaCli$;
import scala.cli.commands.CommandUtils$;
import scala.cli.commands.ScalaCommand;
import scala.cli.commands.SpecificationLevel;
import scala.cli.commands.shared.HelpCommandGroup$;
import scala.cli.commands.shared.HelpGroup$;
import scala.cli.commands.update.Update$;
import scala.cli.commands.version.VersionOptions;
import scala.cli.commands.version.VersionOptions$;
import scala.cli.signing.shared.Secret;
import scala.cli.util.ArgHelpers$;
import scala.collection.StringOps$;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Version$
extends ScalaCommand<VersionOptions> {
    public static final Version$ MODULE$ = new Version$();

    private Version$() {
        super(VersionOptions$.MODULE$.parser(), VersionOptions$.MODULE$.help());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Version$.class);
    }

    public String group() {
        return HelpCommandGroup$.Miscellaneous.toString();
    }

    @Override
    public SpecificationLevel scalaSpecificationLevel() {
        this.SpecificationLevel();
        return SpecificationLevel.SHOULD$.MODULE$;
    }

    @Override
    public HelpFormat helpFormat() {
        return ArgHelpers$.MODULE$.withPrimaryGroup(ArgHelpers$.MODULE$.withHiddenGroupWhenShowHidden(ArgHelpers$.MODULE$.withHiddenGroup(super.helpFormat(), HelpGroup$.Logging), HelpGroup$.Logging), HelpGroup$.Version);
    }

    @Override
    public void runCommand(VersionOptions options, RemainingArgs args, Logger logger) {
        LazyRef lazyRef = new LazyRef();
        if (options.cliVersion()) {
            Predef$.MODULE$.println((Object)Constants$.MODULE$.version());
            return;
        }
        if (options.scalaVersion()) {
            Predef$.MODULE$.println((Object)ScalaCli$.MODULE$.getDefaultScalaVersion());
            return;
        }
        Predef$.MODULE$.println((Object)this.versionInfo());
        if (!options.offline()) {
            this.maybeNewerScalaCliVersion$1(lazyRef, options, logger).foreach((Function1)(JProcedure1 & Serializable)v -> logger.message(() -> this.runCommand$$anonfun$1$$anonfun$1(v)));
            return;
        }
    }

    private String versionInfo() {
        String version = Constants$.MODULE$.version();
        String detailedVersionOpt = (String)Constants$.MODULE$.detailedVersion().filter((Function1 & Serializable)_$2 -> {
            String string = _$2;
            String string2 = version;
            return string == null ? string2 != null : !string.equals(string2);
        }).fold(this::$anonfun$2, (Function1 & Serializable)_$3 -> new StringBuilder(3).append(" (").append((String)_$3).append(")").toString());
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(44).append(this.fullRunnerName()).append(" version: ").append(version).append(detailedVersionOpt).append("\n       |Scala version (default): ").append(ScalaCli$.MODULE$.getDefaultScalaVersion()).toString()));
    }

    private final String maybeNewerScalaCliVersion$lzyINIT1$1$$anonfun$2(CheckScalaCliVersionError e$1) {
        return e$1.message();
    }

    private final Option maybeNewerScalaCliVersion$lzyINIT1$1(LazyRef maybeNewerScalaCliVersion$lzy1$1, VersionOptions options$1, Logger logger$1) {
        Option option;
        LazyRef lazyRef = maybeNewerScalaCliVersion$lzy1$1;
        synchronized (lazyRef) {
            Object object;
            if (maybeNewerScalaCliVersion$lzy1$1.initialized()) {
                object = maybeNewerScalaCliVersion$lzy1$1.value();
            } else {
                Object object2;
                Either<CheckScalaCliVersionError, String> either = Update$.MODULE$.newestScalaCliVersion((Option<Secret<String>>)options$1.ghToken().map((Function1 & Serializable)_$1 -> _$1.get()));
                if (either instanceof Left) {
                    CheckScalaCliVersionError e = (CheckScalaCliVersionError)((Left)either).value();
                    logger$1.debug(() -> this.maybeNewerScalaCliVersion$lzyINIT1$1$$anonfun$2(e));
                    object2 = None$.MODULE$;
                } else if (either instanceof Right) {
                    String newestScalaCliVersion = (String)((Right)either).value();
                    object2 = CommandUtils$.MODULE$.isOutOfDateVersion(newestScalaCliVersion, Constants$.MODULE$.version()) ? Some$.MODULE$.apply((Object)newestScalaCliVersion) : None$.MODULE$;
                } else {
                    throw new MatchError(either);
                }
                object = maybeNewerScalaCliVersion$lzy1$1.initialize(object2);
            }
            option = (Option)object;
        }
        return option;
    }

    private final Option maybeNewerScalaCliVersion$1(LazyRef maybeNewerScalaCliVersion$lzy1$2, VersionOptions options$2, Logger logger$2) {
        return (Option)(maybeNewerScalaCliVersion$lzy1$2.initialized() ? maybeNewerScalaCliVersion$lzy1$2.value() : this.maybeNewerScalaCliVersion$lzyINIT1$1(maybeNewerScalaCliVersion$lzy1$2, options$2, logger$2));
    }

    private final String runCommand$$anonfun$1$$anonfun$1(String v$1) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(220).append("Your ").append(this.fullRunnerName()).append(" version is outdated. The newest version is ").append(v$1).append("\n               |It is recommended that you update ").append(this.fullRunnerName()).append(" through the same tool or method you used for its initial installation for avoiding the creation of outdated duplicates.").toString()));
    }

    private final String $anonfun$2() {
        return "";
    }
}

