/*
 * Decompiled with CFR 0.152.
 */
package scala.cli.config;

import com.github.plokhotnyuk.jsoniter_scala.core.WriterConfig$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.cli.config.ConfigDb$;
import scala.cli.config.ConfigDb$ConfigDbFormatError$;
import scala.cli.config.Key;
import scala.cli.config.RawJson;
import scala.cli.config.RawJson$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Set;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Properties$;

public final class ConfigDb {
    private Map rawEntries;

    public static Either<ConfigDbFormatError, ConfigDb> apply(byte[] byArray, Option<String> option) {
        return ConfigDb$.MODULE$.apply(byArray, option);
    }

    public static ConfigDb empty() {
        return ConfigDb$.MODULE$.empty();
    }

    public static Either<Exception, ConfigDb> open(Path path) {
        return ConfigDb$.MODULE$.open(path);
    }

    public static Option<String> apply$default$2() {
        return ConfigDb$.MODULE$.apply$default$2();
    }

    public ConfigDb(Map<String, byte[]> rawEntries) {
        this.rawEntries = rawEntries;
    }

    public Map<String, byte[]> rawEntries() {
        return this.rawEntries;
    }

    public void rawEntries_$eq(Map<String, byte[]> x$1) {
        this.rawEntries = x$1;
    }

    public <T> Either<ConfigDbFormatError, Option<T>> get(Key<T> key) {
        Option option = this.rawEntries().get((Object)key.fullName());
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Right().apply((Object)None$.MODULE$);
        }
        if (option instanceof Some) {
            byte[] rawEntryContent = (byte[])((Some)option).value();
            return key.parse(rawEntryContent).left().map((Function1 & Serializable)e -> new ConfigDbFormatError(new StringBuilder(20).append("Error parsing ").append(key.fullName()).append(" value").toString(), (Option<Throwable>)Some$.MODULE$.apply(e))).map((Function1 & Serializable)_$1 -> Some$.MODULE$.apply(_$1));
        }
        throw new MatchError((Object)option);
    }

    public <T> ConfigDb set(Key<T> key, T value) {
        byte[] b = key.write(value);
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key.fullName());
        this.rawEntries_$eq((Map<String, byte[]>)((Map)this.rawEntries().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)b))));
        return this;
    }

    public ConfigDb remove(Key<?> key) {
        this.rawEntries_$eq((Map<String, byte[]>)((Map)this.rawEntries().$minus((Object)key.fullName())));
        return this;
    }

    public <T> Either<ConfigDbFormatError, Option<Seq<String>>> getAsString(Key<T> key) {
        return this.get(key).map((Function1 & Serializable)_$2 -> _$2.map((Function1 & Serializable)value -> key.asString(value)));
    }

    public <T> Either<Key.MalformedValue, ConfigDb> setFromString(Key<T> key, Seq<String> values) {
        return key.fromString(values).map((Function1 & Serializable)typedValue -> this.set(key, typedValue));
    }

    public byte[] dump() {
        Object object = Predef$.MODULE$.byteArrayOps(ConfigDb.serializeMap$1(this.rawEntries(), 0));
        return (byte[])ArrayOps$.MODULE$.$plus$plus$extension(object, (Object)new byte[]{10}, ClassTag$.MODULE$.apply(Byte.TYPE));
    }

    public Either<ConfigDbPermissionsError, BoxedUnit> saveUnsafe(Path path) {
        scala.collection.immutable.Set dirPerms;
        boolean permsOk;
        Path dir = path.getParent();
        if (Properties$.MODULE$.isWin()) {
            Files.createDirectories(dir, new FileAttribute[0]);
            Files.write(path, this.dump(), new OpenOption[0]);
            return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        }
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, PosixFilePermissions.asFileAttribute(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE}))).asJava()));
        }
        boolean bl = permsOk = !(dirPerms = CollectionConverters$.MODULE$.SetHasAsScala(Files.getPosixFilePermissions(dir, new LinkOption[0])).asScala().toSet()).contains((Object)PosixFilePermission.GROUP_READ) && !dirPerms.contains((Object)PosixFilePermission.GROUP_WRITE) && !dirPerms.contains((Object)PosixFilePermission.GROUP_EXECUTE) && !dirPerms.contains((Object)PosixFilePermission.OTHERS_READ) && !dirPerms.contains((Object)PosixFilePermission.OTHERS_WRITE) && !dirPerms.contains((Object)PosixFilePermission.OTHERS_EXECUTE);
        if (permsOk) {
            Files.write(path, Array$.MODULE$.emptyByteArray(), new OpenOption[0]);
            Files.setPosixFilePermissions(path, CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE}))).asJava());
            Files.write(path, this.dump(), new OpenOption[0]);
            return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        }
        return package$.MODULE$.Left().apply((Object)new ConfigDbPermissionsError(dir, (scala.collection.immutable.Set<PosixFilePermission>)dirPerms));
    }

    public Either<Exception, BoxedUnit> save(Path path) {
        return this.saveUnsafe(path);
    }

    private static final byte[] serializeMap$1(Map m, int level) {
        Object object;
        Vector keyValues = (Vector)((StrictOptimizedIterableOps)m.groupBy((Function1 & Serializable)_$3 -> ((String)_$3._1()).split("\\.", 2)[0]).toVector().sortBy((Function1 & Serializable)_$4 -> (String)_$4._1(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Map v = (Map)tuple2._2();
                Map v0 = (Map)v.map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String k1 = (String)tuple2._1();
                        byte[] v1 = (byte[])tuple2._2();
                        return Tuple2$.MODULE$.apply((Object)StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(k1), k)), "."), (Object)v1);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return Tuple2$.MODULE$.apply((Object)k, (Object)ConfigDb.serialize$1(v0, level + 1));
            }
            throw new MatchError((Object)tuple2);
        });
        Map sortedMap = (Map)ListMap$.MODULE$.empty().$plus$plus((IterableOnce)keyValues);
        byte[] b = com.github.plokhotnyuk.jsoniter_scala.core.package$.MODULE$.writeToArray((Object)sortedMap, WriterConfig$.MODULE$.withIndentionStep((level + 1) * 2), ConfigDb$.scala$cli$config$ConfigDb$$$codec);
        Object object2 = Predef$.MODULE$.byteArrayOps(b);
        if (ArrayOps$.MODULE$.nonEmpty$extension(object2) && BoxesRunTime.unboxToByte((Object)ArrayOps$.MODULE$.last$extension(object = Predef$.MODULE$.byteArrayOps(b))) == (byte)125) {
            Object object3 = Predef$.MODULE$.byteArrayOps(b);
            Object object4 = Predef$.MODULE$.byteArrayOps((byte[])ArrayOps$.MODULE$.init$extension(object3));
            Object object5 = Predef$.MODULE$.byteArrayOps((byte[])ArrayOps$.MODULE$.$plus$plus$extension(object4, (Object)StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("  "), level).getBytes(StandardCharsets.US_ASCII), ClassTag$.MODULE$.apply(Byte.TYPE)));
            return (byte[])ArrayOps$.MODULE$.$plus$plus$extension(object5, (Object)new byte[]{(byte)125}, ClassTag$.MODULE$.apply(Byte.TYPE));
        }
        return b;
    }

    private static final RawJson serialize$1(Map m, int level) {
        Option option = m.get((Object)"");
        if (option instanceof Some) {
            byte[] value = (byte[])((Some)option).value();
            if (m.size() == 1) {
                return RawJson$.MODULE$.apply(value);
            }
            throw scala.sys.package$.MODULE$.error(new StringBuilder(19).append("Inconsistent keys: ").append(m.keySet().toVector().sorted((Ordering)Ordering.String$.MODULE$)).toString());
        }
        if (None$.MODULE$.equals(option)) {
            return RawJson$.MODULE$.apply(ConfigDb.serializeMap$1(m, level));
        }
        throw new MatchError((Object)option);
    }

    public static final class ConfigDbFormatError
    extends Exception {
        public static Option<Throwable> $lessinit$greater$default$2() {
            return ConfigDb$ConfigDbFormatError$.MODULE$.$lessinit$greater$default$2();
        }

        public ConfigDbFormatError(String message, Option<Throwable> causeOpt) {
            super(message, (Throwable)causeOpt.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }
    }

    public static final class ConfigDbPermissionsError
    extends Exception {
        public ConfigDbPermissionsError(Path path, scala.collection.immutable.Set<PosixFilePermission> perms) {
            super(new StringBuilder(52).append(path).append(" has wrong permissions ").append(ConfigDb$.MODULE$.scala$cli$config$ConfigDb$$$permsString(perms)).append(" (expected at most rwx------)").toString());
        }
    }
}

