/*
 * Decompiled with CFR 0.152.
 */
package libsodiumjni.internal;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;

public final class LoadLibrary {
    private static boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initialize(String string) {
        if (initialized) return;
        Class<LoadLibrary> clazz = LoadLibrary.class;
        synchronized (LoadLibrary.class) {
            System.load(string);
            initialized = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static String resourcePath() {
        String string = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (string.contains("linux")) {
            return "META-INF/native/linux64/libsodiumjni.so";
        }
        if (string.contains("mac")) {
            return "META-INF/native/darwin/libsodiumjni.dylib";
        }
        if (string.contains("windows")) {
            return "META-INF/native/windows64/libsodiumjni.dll";
        }
        throw new RuntimeException("Unrecognized or unsupported OS: " + string);
    }

    public static String libSuffix() {
        String string = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (string.contains("linux")) {
            return ".so";
        }
        if (string.contains("mac")) {
            return ".dylib";
        }
        if (string.contains("windows")) {
            return ".dll";
        }
        throw new RuntimeException("Unrecognized or unsupported OS: " + string);
    }

    public static void initializeFromResources() throws IOException {
        LoadLibrary.initializeFromResources(LoadLibrary.resourcePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initializeFromResources(String string) throws IOException {
        if (initialized) return;
        Class<LoadLibrary> clazz = LoadLibrary.class;
        synchronized (LoadLibrary.class) {
            URL uRL = Thread.currentThread().getContextClassLoader().getResource(string);
            if (uRL == null) {
                throw new RuntimeException("Resource " + string + " not found");
            }
            byte[] byArray = uRL.openStream().readAllBytes();
            Path path = Files.createTempFile("libsodium", LoadLibrary.libSuffix(), new FileAttribute[0]);
            Files.write(path, byArray, new OpenOption[0]);
            System.load(path.toString());
            initialized = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void assumeInitialized() {
        initialized = true;
    }
}

