/*
 * Decompiled with CFR 0.152.
 */
package scala.cli.graal;

import geny.Writable$;
import java.io.Serializable;
import os.Path;
import os.PathChunk;
import os.PathChunk$;
import os.RelPath;
import os.RelPath$;
import os.Source;
import os.Source$;
import os.exists$;
import os.isDir$;
import os.makeDir;
import os.package$;
import os.size$;
import os.write$;
import scala.Function1;
import scala.Product;
import scala.cli.graal.ClassPathEntry;
import scala.cli.graal.CoursierCache$;
import scala.cli.graal.CreatedEntry$;
import scala.cli.graal.JarCache;
import scala.cli.graal.Processed$;
import scala.cli.graal.TempCache$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class CoursierCache
implements JarCache,
Product,
Serializable {
    private final Path root;
    private final Function1 hasher;
    private final String prefix;
    private final Path cache;

    public static CoursierCache apply(Path path) {
        return CoursierCache$.MODULE$.apply(path);
    }

    public static CoursierCache fromProduct(Product product) {
        return CoursierCache$.MODULE$.fromProduct(product);
    }

    public static CoursierCache unapply(CoursierCache coursierCache) {
        return CoursierCache$.MODULE$.unapply(coursierCache);
    }

    public CoursierCache(Path root) {
        this.root = root;
        this.hasher = (Function1 & Serializable)p -> BoxesRunTime.boxToLong((long)size$.MODULE$.apply(p)).toString();
        this.prefix = "v2";
        this.cache = root.$div((PathChunk)new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(PathChunk$.MODULE$.segmentsFromString(".graal_processor"))));
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof CoursierCache)) return false;
        CoursierCache coursierCache = (CoursierCache)object;
        Path path = this.root();
        Path path2 = coursierCache.root();
        if (path == null) {
            if (path2 != null) {
                return false;
            }
        } else if (!path.equals(path2)) return false;
        if (!coursierCache.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof CoursierCache;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "CoursierCache";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "root";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Path root() {
        return this.root;
    }

    public Function1<Path, String> hasher() {
        return this.hasher;
    }

    public String prefix() {
        return this.prefix;
    }

    public Path cache() {
        return this.cache;
    }

    @Override
    public ClassPathEntry put(RelPath entry, byte[] content) {
        String name = new StringBuilder(3).append(entry.baseName()).append("_").append(content.length).append("_").append(this.prefix()).append(".").append(entry.ext()).toString();
        Path dest = this.cache().$div((PathChunk)PathChunk$.MODULE$.RelPathChunk(entry)).$div((PathChunk)PathChunk$.MODULE$.RelPathChunk(package$.MODULE$.up())).$div((PathChunk)new PathChunk.StringPathChunk(name));
        if (!exists$.MODULE$.apply(dest)) {
            makeDir.all$.MODULE$.apply(dest.$div((PathChunk)PathChunk$.MODULE$.RelPathChunk(package$.MODULE$.up())));
            write$.MODULE$.apply(dest, (Source)Source$.MODULE$.WritableSource((Object)content, (Function1 & Serializable)a -> Writable$.MODULE$.ByteArrayWritable(a)), write$.MODULE$.apply$default$3(), write$.MODULE$.apply$default$4());
        }
        return CreatedEntry$.MODULE$.apply(dest);
    }

    @Override
    public ClassPathEntry cache(Path path, Function1<Path, ClassPathEntry> processPath) {
        if (!path.startsWith(this.root()) || isDir$.MODULE$.apply(path)) {
            return CoursierCache.ignore$1(path, processPath);
        }
        RelPath relPath = path.relativeTo(this.root());
        String name = new StringBuilder(3).append(path.baseName()).append("_").append(this.hasher().apply((Object)path)).append("_").append(this.prefix()).append(".").append(path.ext()).toString();
        Path dest = this.cache().$div((PathChunk)PathChunk$.MODULE$.RelPathChunk(relPath)).$div((PathChunk)PathChunk$.MODULE$.RelPathChunk(package$.MODULE$.up())).$div((PathChunk)new PathChunk.StringPathChunk(name));
        if (exists$.MODULE$.apply(dest)) {
            return Processed$.MODULE$.apply(dest, path, this);
        }
        return (ClassPathEntry)processPath.apply((Object)dest);
    }

    public CoursierCache copy(Path root) {
        return new CoursierCache(root);
    }

    public Path copy$default$1() {
        return this.root();
    }

    public Path _1() {
        return this.root();
    }

    private static final ClassPathEntry ignore$1(Path path$1, Function1 processPath$1) {
        return TempCache$.MODULE$.cache(path$1, (Function1<Path, ClassPathEntry>)processPath$1);
    }
}

