/*
 * Decompiled with CFR 0.152.
 */
package scala.build.testrunner;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import sbt.testing.AnnotatedFingerprint;
import sbt.testing.Event;
import sbt.testing.Fingerprint;
import sbt.testing.Framework;
import sbt.testing.Runner;
import sbt.testing.Selector;
import sbt.testing.Status;
import sbt.testing.SubclassFingerprint;
import sbt.testing.SuiteSelector;
import sbt.testing.Task;
import sbt.testing.TaskDef;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.build.testrunner.AsmTestRunner;
import scala.build.testrunner.TestRunner$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class AsmTestRunner$ {
    public static final AsmTestRunner$ MODULE$ = new AsmTestRunner$();

    public Option<Fingerprint> matchFingerprints(String className, Function0<InputStream> byteCode, Seq<Fingerprint> fingerprints, AsmTestRunner.ParentInspector parentInspector) {
        boolean definitelyNoTests;
        AsmTestRunner.TestClassChecker checker = new AsmTestRunner.TestClassChecker();
        try (InputStream is0 = null;){
            is0 = (InputStream)byteCode.apply();
            ClassReader reader = new ClassReader(is0);
            reader.accept((ClassVisitor)checker, 0);
        }
        boolean isModule = className.endsWith("$");
        boolean hasPublicConstructors = checker.publicConstructorCount() > 0;
        boolean bl = definitelyNoTests = checker.isAbstract() || checker.isInterface() || checker.publicConstructorCount() > 1 || isModule == hasPublicConstructors;
        if (definitelyNoTests) {
            return None$.MODULE$;
        }
        return fingerprints.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AsmTestRunner$.$anonfun$matchFingerprints$1(isModule, parentInspector, checker, x0$1)));
    }

    public Iterator<Tuple2<String, Function0<InputStream>>> listClassesByteCode(Path classPathEntry, boolean keepJars) {
        if (Files.isDirectory(classPathEntry, new LinkOption[0])) {
            Iterator iterator;
            try (Stream<Path> stream = null;){
                stream = Files.walk(classPathEntry, Integer.MAX_VALUE, new FileVisitOption[0]);
                iterator = CollectionConverters$.MODULE$.IteratorHasAsScala(stream.iterator()).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AsmTestRunner$.$anonfun$listClassesByteCode$1(x$1))).map((Function1 & Serializable)x$2 -> x$2.toAbsolutePath()).map((Function1 & Serializable)p -> {
                    String clsName = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(((Object)classPathEntry.relativize((Path)p)).toString()), ".class");
                    return new Tuple2((Object)clsName, (Function0 & Serializable)() -> AsmTestRunner$.openStream$1(p));
                }).toVector().iterator();
            }
            return iterator;
        }
        if (keepJars && Files.isRegularFile(classPathEntry, new LinkOption[0])) {
            Iterator iterator;
            byte[] buf = (byte[])Array$.MODULE$.ofDim(16384, (ClassTag)ClassTag$.MODULE$.Byte());
            ObjectRef zf = ObjectRef.create(null);
            try {
                zf.elem = new ZipFile(classPathEntry.toFile());
                iterator = CollectionConverters$.MODULE$.EnumerationHasAsScala(((ZipFile)zf.elem).entries()).asScala().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AsmTestRunner$.$anonfun$listClassesByteCode$5(x$3))).map((Function1 & Serializable)ent -> {
                    Tuple2 tuple2;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try (InputStream is = null;){
                        is = ((ZipFile)zf$1.elem).getInputStream((ZipEntry)ent);
                        int read = -1;
                        while ((read = is.read(buf)) >= 0) {
                            baos.write(buf, 0, read);
                        }
                        String clsName = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(ent.getName()), ".class");
                        tuple2 = new Tuple2((Object)clsName, (Function0 & Serializable)() -> AsmTestRunner$.openStream$2(baos));
                    }
                    return tuple2;
                }).toVector().iterator();
            }
            finally {
                if ((ZipFile)zf.elem != null) {
                    ((ZipFile)zf.elem).close();
                }
            }
            return iterator;
        }
        return package$.MODULE$.Iterator().empty();
    }

    public Iterator<Tuple2<String, Function0<InputStream>>> listClassesByteCode(Seq<Path> classPath, boolean keepJars) {
        return classPath.iterator().flatMap((Function1 & Serializable)x$4 -> MODULE$.listClassesByteCode((Path)x$4, keepJars));
    }

    public Option<byte[]> findInClassPath(Path classPathEntry, String name) {
        if (Files.isDirectory(classPathEntry, new LinkOption[0])) {
            Path p = classPathEntry.resolve(name);
            if (Files.isRegularFile(p, new LinkOption[0])) {
                return new Some((Object)Files.readAllBytes(p));
            }
            return None$.MODULE$;
        }
        if (Files.isRegularFile(classPathEntry, new LinkOption[0])) {
            Option option;
            byte[] buf = (byte[])Array$.MODULE$.ofDim(16384, (ClassTag)ClassTag$.MODULE$.Byte());
            ObjectRef zf = ObjectRef.create(null);
            try {
                zf.elem = new ZipFile(classPathEntry.toFile());
                option = Option$.MODULE$.apply((Object)((ZipFile)zf.elem).getEntry(name)).map((Function1 & Serializable)ent -> {
                    byte[] byArray;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try (InputStream is = null;){
                        is = ((ZipFile)zf$2.elem).getInputStream((ZipEntry)ent);
                        int read = -1;
                        while ((read = is.read(buf)) >= 0) {
                            baos.write(buf, 0, read);
                        }
                        byArray = baos.toByteArray();
                    }
                    return byArray;
                });
            }
            finally {
                if ((ZipFile)zf.elem != null) {
                    ((ZipFile)zf.elem).close();
                }
            }
            return option;
        }
        return None$.MODULE$;
    }

    public Option<byte[]> findInClassPath(Seq<Path> classPath, String name) {
        return classPath.iterator().flatMap((Function1 & Serializable)x$5 -> MODULE$.findInClassPath((Path)x$5, name).iterator()).take(1).toList().headOption();
    }

    public Option<String> findFrameworkService(Seq<Path> classPath) {
        return this.findInClassPath(classPath, "META-INF/services/sbt.testing.Framework").map((Function1 & Serializable)b -> new String((byte[])b, StandardCharsets.UTF_8));
    }

    public Option<String> findFramework(Seq<Path> classPath, Seq<String> preferredClasses) {
        AsmTestRunner.ParentInspector parentInspector = new AsmTestRunner.ParentInspector(classPath);
        return this.findFramework(classPath, preferredClasses, parentInspector);
    }

    public Option<String> findFramework(Seq<Path> classPath, Seq<String> preferredClasses, AsmTestRunner.ParentInspector parentInspector) {
        Iterator preferredClassesByteCode = preferredClasses.iterator().map((Function1 & Serializable)x$6 -> x$6.replace('.', '/')).flatMap((Function1 & Serializable)name -> MODULE$.findInClassPath(classPath, new StringBuilder(6).append((String)name).append(".class").toString()).iterator().map((Function1 & Serializable)b -> new Tuple2(name, (Function0 & Serializable)() -> AsmTestRunner$.openStream$3(b))));
        return preferredClassesByteCode.$plus$plus((Function0 & Serializable)() -> MODULE$.listClassesByteCode(classPath, true)).flatMap((Function1 & Serializable)x0$1 -> {
            String moduleInfo;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null && (moduleInfo = (String)tuple2._1()).contains("module-info")) {
                return package$.MODULE$.Iterator().empty();
            }
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Function0 is = (Function0)tuple2._2();
                AsmTestRunner.TestClassChecker checker = new AsmTestRunner.TestClassChecker();
                try (InputStream is0 = null;){
                    is0 = (InputStream)is.apply();
                    ClassReader reader = new ClassReader(is0);
                    reader.accept((ClassVisitor)checker, 0);
                }
                boolean isFramework = parentInspector.allParents(name).contains((Object)"sbt/testing/Framework");
                if (isFramework && !checker.isAbstract() && checker.publicConstructorCount() == 1) {
                    return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name}));
                }
                return package$.MODULE$.Iterator().empty();
            }
            throw new MatchError((Object)tuple2);
        }).take(1).toList().headOption();
    }

    public Iterator<TaskDef> taskDefs(Seq<Path> classPath, boolean keepJars, Seq<Fingerprint> fingerprints, AsmTestRunner.ParentInspector parentInspector) {
        return this.listClassesByteCode(classPath, keepJars).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Function0 is = (Function0)tuple2._2();
                return MODULE$.matchFingerprints(name, (Function0<InputStream>)is, fingerprints, parentInspector).map((Function1 & Serializable)x$8 -> new Tuple2((Object)StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(name), "$"), x$8)).iterator();
            }
            throw new MatchError((Object)tuple2);
        }).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String clsName = (String)tuple2._1();
                Fingerprint fp = (Fingerprint)tuple2._2();
                return new TaskDef(clsName.replace('/', '.').replace('\\', '.'), fp, false, (Selector[])((Object[])new Selector[]{new SuiteSelector()}));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public void main(String[] args) {
        boolean failed;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Seq<Path> classPath = TestRunner$.MODULE$.classPath(classLoader);
        AsmTestRunner.ParentInspector parentCache = new AsmTestRunner.ParentInspector(classPath);
        String frameworkClassName = ((String)this.findFrameworkService(classPath).orElse((Function0 & Serializable)() -> MODULE$.findFramework(classPath, TestRunner$.MODULE$.commonTestFrameworks(), parentCache)).getOrElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.error("No test framework found"))).replace('/', '.').replace('\\', '.');
        Framework framework = (Framework)classLoader.loadClass(frameworkClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        PrintStream out = System.out;
        TaskDef[] taskDefs0 = (TaskDef[])this.taskDefs(classPath, false, (Seq<Fingerprint>)ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.refArrayOps((Object[])framework.fingerprints())), parentCache).toArray(ClassTag$.MODULE$.apply(TaskDef.class));
        Runner runner = framework.runner((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), classLoader);
        Task[] initialTasks = runner.tasks(taskDefs0);
        Seq<Event> events = TestRunner$.MODULE$.runTasks((Seq<Task>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)initialTasks), out);
        String doneMsg = runner.done();
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(doneMsg))) {
            out.println(doneMsg);
        }
        if (failed = events.exists((Function1 & Serializable)ev -> BoxesRunTime.boxToBoolean((boolean)AsmTestRunner$.$anonfun$main$3(ev)))) {
            throw scala.sys.package$.MODULE$.exit(1);
        }
    }

    public static final /* synthetic */ boolean $anonfun$matchFingerprints$1(boolean isModule$1, AsmTestRunner.ParentInspector parentInspector$1, AsmTestRunner.TestClassChecker checker$1, Fingerprint x0$1) {
        Fingerprint fingerprint = x0$1;
        if (fingerprint instanceof SubclassFingerprint) {
            SubclassFingerprint subclassFingerprint = (SubclassFingerprint)fingerprint;
            return subclassFingerprint.isModule() == isModule$1 && parentInspector$1.allParents(checker$1.name()).contains((Object)subclassFingerprint.superclassName().replace('.', '/'));
        }
        if (fingerprint instanceof AnnotatedFingerprint) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        throw new MatchError((Object)fingerprint);
    }

    public static final /* synthetic */ boolean $anonfun$listClassesByteCode$1(Path x$1) {
        return ((Object)x$1.getFileName()).toString().endsWith(".class");
    }

    private static final InputStream openStream$1(Path p$1) {
        return Files.newInputStream(p$1, new OpenOption[0]);
    }

    public static final /* synthetic */ boolean $anonfun$listClassesByteCode$5(ZipEntry x$3) {
        return x$3.getName().endsWith(".class");
    }

    private static final ByteArrayInputStream openStream$2(ByteArrayOutputStream baos$1) {
        return new ByteArrayInputStream(baos$1.toByteArray());
    }

    private static final ByteArrayInputStream openStream$3(byte[] b$1) {
        return new ByteArrayInputStream(b$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$main$3(Event ev) {
        Status status = ev.status();
        Status status2 = Status.Error;
        if (status == null) {
            if (status2 == null) return true;
        } else if (status.equals(status2)) return true;
        Status status3 = ev.status();
        Status status4 = Status.Failure;
        if (status3 == null) {
            if (status4 == null) return true;
        } else if (status3.equals(status4)) return true;
        Status status5 = ev.status();
        Status status6 = Status.Canceled;
        if (status5 != null) {
            if (!status5.equals(status6)) return false;
            return true;
        }
        if (status6 == null) return true;
        return false;
    }

    private AsmTestRunner$() {
    }
}

